/*
There are list of songs.
When pressing song-icon it will start playing alone ( on ad-hoc sequencer).
 Pressing another song-icon will stop previous song.

If vocal-button is toggled, vocal-version of track is used.


Last selected/listened will be used when user press 'OK'-button.
Cancel-button returns without modification.

*/
#include <glib-object.h>
#include <tangle.h>


#include "../../meam/jammo-meam.h"
#include "../../meam/jammo-backing-track.h"


#include "../jammo.h"
#include "../../configure.h"
#include "../file_helper.h"
#include "sequencer.h"
#include <string.h>

//Only one of these can be toggled down at a time.
static gboolean vocal_selected = FALSE;
static gboolean melodic_selected = FALSE;

static gchar* last_played_filename=NULL;
static gchar* image_name_for_last_played=NULL;
static GList* visible_borders = NULL; //Actors for frames surrounding selected image


static JammoSequencer* adhoc_sequencer=NULL;
static void on_sequencer_stopped(JammoSequencer* sequencer, gpointer user_data) {
	printf("backingtrack_selection.c: on_sequencer_stopped\n");
	g_object_unref(sequencer);
	adhoc_sequencer=NULL;
}



static void show_and_add_to_list(ClutterActor* actor, gpointer none) {
	//printf("show borders and add them to list\n");
	clutter_actor_show(actor);
	visible_borders=g_list_append(visible_borders,actor);
}

static void clear_list_and_make_new(){
	if (visible_borders){
		g_list_foreach(visible_borders, (GFunc)clutter_actor_hide,NULL);
		g_list_free(visible_borders);
	}

	visible_borders = NULL; //make new
}

void backingtrack_song_clicked (TangleButton* tanglebutton, gpointer none){
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(tanglebutton));
	printf("backingtrack_song_clicked: '%s'\n",name);
	//Remove and add frames for selected.
	clear_list_and_make_new(); //for visible_borders
	ClutterActor* actor = tangle_button_get_normal_background_actor(tanglebutton);
	clutter_container_foreach(CLUTTER_CONTAINER(actor), CLUTTER_CALLBACK(show_and_add_to_list), NULL);

	JammoSequencer* global_sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));

	//Vocal or accompaniment only
	gchar* prefix;
	gchar* postfix=""; //e.g. language
	if (vocal_selected) {
		prefix = "SaV";
		//TODO: use menu for flags to determine this
		postfix="_fi";


		//If vocal is used, set tempo to 110. (As designed!)
		if (strcmp(name,"pendolino")==0) //This is exception
			jammo_sequencer_set_tempo(global_sequencer,130);
		else if (strcmp(name,"LaBamba")==0)   //This is exception
			jammo_sequencer_set_tempo(global_sequencer,130); //TODO: currently start 130_fi.
			//postfix=""; //It has all tempo-variations. It doesn't have postfix for language
		else if (strcmp(name,"SiyaHamba")==0)   //This is exception
			postfix=""; //It has all tempo-variations. It doesn't have postfix for language
		else if (strcmp(name,"banana")==0)   //This is exception
			postfix=""; //It has all tempo-variations. It doesn't have postfix for language
		else if (strcmp(name,"brotherjohn")==0)   //This is exception
				jammo_sequencer_set_tempo(global_sequencer,90);
		else if ( (strcmp(name,"ScarboroughFairGrime")==0) ||     //This is exception
              (strcmp(name,"ScarboroughFairFolkMetal")==0) ||
              (strcmp(name,"ScarFairSouthAsian")==0) )
			postfix="_en";  //These have all tempo-variations. Language is only for en.


		else
			jammo_sequencer_set_tempo(global_sequencer,110);
	}
	else if (melodic_selected)
		prefix ="SaM";
	else
		prefix ="Sa";

	gchar* backing_track_filename = g_strdup_printf("%s/backingtracks/%s_%s_$t_$p%s.ogg",AUDIO_DIR,prefix,name,postfix);
	printf ("looking backing_track_filename: '%s'\n",backing_track_filename);
	if (adhoc_sequencer){
		jammo_sequencer_stop(adhoc_sequencer);
	}

	adhoc_sequencer = jammo_sequencer_new();
	jammo_sequencer_set_tempo(adhoc_sequencer,jammo_sequencer_get_tempo(global_sequencer));
	jammo_sequencer_set_pitch(adhoc_sequencer,jammo_sequencer_get_pitch(global_sequencer));
	//printf("tempo and pitch set\n");

	JammoTrack* track = JAMMO_TRACK(jammo_backing_track_new(backing_track_filename));
	jammo_sequencer_add_track(adhoc_sequencer, JAMMO_TRACK(track));
	if (last_played_filename)
		g_free(last_played_filename);
	last_played_filename = g_strdup_printf("%s",backing_track_filename);
	image_name_for_last_played = g_strdup_printf("icon_%s.png",name);

	g_signal_connect(adhoc_sequencer, "stopped", G_CALLBACK(on_sequencer_stopped), NULL);
	jammo_sequencer_play(adhoc_sequencer);
}


void backingtrack_selection_vocal_clicked(TangleButton* tanglebutton, gpointer none){
	printf("backingtrack_selection_vocal_clicked\n");
	vocal_selected = tangle_button_get_selected(tanglebutton);

	if (vocal_selected) {
	 tangle_button_set_selected(TANGLE_BUTTON(jammo_get_actor_by_id("backingtrack-selection-melodical")),FALSE);
	 melodic_selected=FALSE;
	}
}

void backingtrack_selection_melodical_clicked(TangleButton* tanglebutton, gpointer none){
	printf("backingtrack_selection_vocal_clicked\n");
	melodic_selected = tangle_button_get_selected(tanglebutton);

	if (melodic_selected) {
	 tangle_button_set_selected(TANGLE_BUTTON(jammo_get_actor_by_id("backingtrack-selection-vocal")),FALSE);
	 vocal_selected=FALSE;
	}
}

static void end_backingtrack_selection() {
	if (adhoc_sequencer) {
		jammo_sequencer_stop(adhoc_sequencer);
		g_object_unref(adhoc_sequencer);
		adhoc_sequencer=NULL;
	}

	if (last_played_filename) {
		g_free(last_played_filename);
		last_played_filename=NULL;
	}

	if (image_name_for_last_played) {
		g_free(image_name_for_last_played);
		image_name_for_last_played=NULL;
	}

	clutter_actor_hide(jammo_get_actor_by_id("backingtrack-selection-view"));
	return_to_fullsequencer_gui();
}


void backingtrack_selection_ok_clicked(TangleButton* tanglebutton, gpointer none){
	printf("backingtrack_selection_ok_clicked\n");

	if (last_played_filename) {
		//Convention: There are always one backing-track-view, with this ID.
		ClutterActor* track_view = jammo_get_actor_by_id("backing-track-view");
		if (track_view) {
			//audio
			JammoTrack* track = NULL;
			g_object_get(track_view,"track",&track,NULL);
			if (track) {
				g_object_set(track,"filename",last_played_filename,NULL);
			} else {
				printf("Can't change backingtrack audio! No track found. Will not change image\n");
				return;
			}

			//image
			gchar* image_file = g_build_filename(DATA_DIR, "backingtracks",image_name_for_last_played,NULL);
			//printf ("image_file '%s'\n",image_file);
			ClutterActor* new_back = clutter_texture_new_from_file(image_file, NULL);
			if (new_back==NULL) {
				printf("Can't find image. Using gray texture.\n");
				new_back = clutter_rectangle_new_with_color (clutter_color_new(100,100,100,100));
				clutter_actor_set_size(new_back, clutter_actor_get_width(track_view), clutter_actor_get_height(track_view));
			}
			else {
				g_object_set(new_back,"repeat-x", TRUE,NULL);
			}
			tangle_widget_set_background_actor(TANGLE_WIDGET(track_view),new_back);

		}
	}

end_backingtrack_selection();
}


void backingtrack_selection_cancel_clicked(TangleButton* tanglebutton, gpointer none){
	printf("backingtrack_selection_cancel_clicked\n");
	end_backingtrack_selection();
}

#define step_height 130
static void roll_song_list(int direction) {
	ClutterActor* scrolling_view = jammo_get_actor_by_id("backingtrack-selection-container");
	ClutterAction* action = tangle_actor_get_action_by_type(scrolling_view,TANGLE_TYPE_SCROLL_ACTION);
	float old_value;
	g_object_get(action, "offset-y", &old_value, NULL);
	 //Rounding
	int steps = old_value / step_height;
	old_value = steps * step_height;
	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 250, "offset-y", old_value + (direction*step_height), NULL);
}

void backingtrack_up_arrow_clicked(TangleButton* tanglebutton, gpointer none){
	printf("backingtrack_up_arrow_clicked\n");
	roll_song_list(-1); //up
}


void backingtrack_down_arrow_clicked(TangleButton* tanglebutton, gpointer none){
printf("backingtrack_down_arrow_clicked\n");
	roll_song_list(1); //down
}

//Set clamping after view is visible. It does not harm when called second time.
void backingtrack_selection_show_completed(TangleAction *tangleaction, GObject *source, const gchar *trigger, TangleProperties *properties){
	clear_list_and_make_new(); //for visible_borders
	ClutterActor* actor = jammo_get_actor_by_id("backingtrack-selection-container");
	if (actor) {
		ClutterAction* action = tangle_actor_get_action_by_type(actor, TANGLE_TYPE_SCROLL_ACTION);
		if (action)
			g_signal_connect_swapped(action, "clamp-offset-y", G_CALLBACK(tangle_widget_clamp_child_boundaries), actor);
	}

}

