/*
License: GPLv2, read more from COPYING

This file contains the functionality of help menu.
 */
#include <tangle.h>
#include <string.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"
#include "help.h"
#include "community_utilities.h"
#include "single_thread.h"
#include "src/configure.h"
#include <libintl.h>
#include "../../cem/cem.h"

static ClutterContainer *questionlist = 0;
static gint listItemHeight = 0;
static int selectedQuestion = 0;
static GList *helpdesk_messages = 0;

TextField addquestion_titleTextField;
TextField addquestion_questionTextField;

void start_helpdesk()
{
	cem_add_to_log(_("Starting Helpdesk"), J_LOG_DEBUG);
	helpdesk_messages = 0;
	helpdesk_get_questions();
	helpdesk_show_helpdesk_view();
}

void helpdesk_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(questionlist);
	clear_messagelist(helpdesk_messages);
	g_list_free(helpdesk_messages);
	start_communitymenu();
}

void helpdesk_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(questionlist);
	clear_messagelist(helpdesk_messages);
	g_list_free(helpdesk_messages);
	startmenu_goto_startmenu(tanglebutton, none);
}

void helpdesk_return_from_threads_view(GList *messagelist)
{
	helpdesk_messages = messagelist;
	helpdesk_show_helpdesk_view();
}

gboolean helpdesk_mentor_clicked (TangleButton *tanglebutton, gpointer data)   
{
	cem_add_to_log(_("Mentor Clicked"), J_LOG_DEBUG);
	return TRUE;
}

void helpdesk_get_questions(void)
{
	//TODO: Create code for fetching helpdesk questions from remote server
	cem_add_to_log(_("Fetching Questions From Community Server"), J_LOG_DEBUG);
}

GList* helpdesk_get_number_of_questions(void)
{
	GList *temp = 0;

	helpdesk_messages = g_list_first(helpdesk_messages);

	int index = 0;

	if(g_list_length(helpdesk_messages) != 0)
	{
		message *temp_msg = helpdesk_messages->data;

		temp = g_list_append(temp, (gpointer)temp_msg);

		while(helpdesk_messages->next != NULL)
		{
			helpdesk_messages = helpdesk_messages->next;

			message *temp_msg = helpdesk_messages->data;

			if(temp_msg->index > index) 
			{
				index = temp_msg->index;
				temp = g_list_append(temp, (gpointer)temp_msg);
			}
		}
		g_list_first(temp);
		return temp;
	}
	else
	return NULL;
}

void helpdesk_show_helpdesk_view(void)
{
	GList *questions = helpdesk_get_number_of_questions();

	int number_of_questions = g_list_length(questions);
	int i = 0;

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	ClutterActor* help_view = jammo_get_actor_by_id("helpdesk-view");

	if(help_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(help_view));
		clutter_actor_show(jammo_get_actor_by_id("helpdesk-no-questions-textfield"));

		if(number_of_questions > 4)
		{
			questionlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("helpdesk-list-scrollable"));	
			ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(questionlist), TANGLE_TYPE_SCROLL_ACTION);
			g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(helpdesk_autoscroll_to_correct_pos), questionlist);
		}
		else	questionlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("helpdesk-list-unscrollable"));

		if(number_of_questions != 0)
		{	
			clutter_actor_hide(jammo_get_actor_by_id("helpdesk-no-questions-textfield"));
			
			do{	
				if(i > 0)
				questions = questions->next;

				message *msg = questions->data;

				helpdesk_add_question_to_list(msg, i);
				i++;
			}while(questions->next != NULL);
		}
	}
	else 	cem_add_to_log(_("Can't find 'helpdesk-view'"), J_LOG_DEBUG);

	g_list_free(questions);
}

void helpdesk_show_question_view(ClutterActor *actor)
{
 	helpdesk_find_selected_actor(actor);

	clear_container(questionlist);	

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

	///TRANSLATORS: Leave %d as is because it is needed
	printf(_("Showing Question: %d"), selectedQuestion);

	start_thread_view(helpdesk_messages, "helpdesk", NULL, selectedQuestion);

}

void helpdesk_show_addquestion_view(void)
{
	cem_add_to_log(_("Starting AddQuestion View"), J_LOG_DEBUG);

	clear_container(questionlist);

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* comment_view = jammo_get_actor_by_id("helpdesk-addquestion-view");	

	if(comment_view) 
	{
		clutter_actor_show(CLUTTER_ACTOR(comment_view));

		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("helpdesk-addquestion-title")), _("Add Your Topic Here"));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("helpdesk-addquestion-description")), _("Add Your Question Here"));

		addquestion_titleTextField.text = jammo_get_actor_by_id("helpdesk-addquestion-title");
		addquestion_titleTextField.lineCount = 3;
		addquestion_titleTextField.handler_id = g_signal_connect_swapped(addquestion_titleTextField.text,
							"text-changed", (GCallback)limit_line_count, &addquestion_titleTextField);		

		addquestion_questionTextField.text = jammo_get_actor_by_id("helpdesk-addquestion-description");
		addquestion_questionTextField.lineCount = 9;
		addquestion_questionTextField.handler_id = g_signal_connect_swapped(addquestion_questionTextField.text,
							"text-changed", (GCallback)limit_line_count, &addquestion_questionTextField);		
	}

	else 	puts("can't find 'helpdesk-addquestion-view' ");
}

void helpdesk_add_question(void)
{
	cem_add_to_log(_("Adding Question"), J_LOG_DEBUG);

	int index = 0;

	helpdesk_messages = g_list_first(helpdesk_messages);

	if(g_list_length(helpdesk_messages) != 0)
	{
		while(helpdesk_messages->next != NULL)
		{
			helpdesk_messages = helpdesk_messages->next;

			message *temp = helpdesk_messages->data;

			if(temp->index > index)
			index = temp->index;
		}

		index++;
	}

	//Next we add the message to helpdesk_messages list

	message *msg = 0;
	time_type now;

	now = get_current_time();

	msg = malloc(sizeof (message));
	msg->index = index;
	msg->msg = malloc(strlen(clutter_text_get_text(CLUTTER_TEXT(addquestion_questionTextField.text)))+1);
	strcpy(msg->msg, clutter_text_get_text(CLUTTER_TEXT(addquestion_questionTextField.text)));
	strcpy(msg->avatar, "Avatar");
	strncpy(msg->title, clutter_text_get_text(CLUTTER_TEXT(addquestion_titleTextField.text)), 100);
	msg->title[99] = 0;
	strncpy(msg->sender, "Sender",20);
	msg->sender[19] = 0;
	strcpy(msg->time, now.time); 

	helpdesk_messages = g_list_append(helpdesk_messages, (gpointer)msg);

	helpdesk_show_helpdesk_view();
}

void helpdesk_autoscroll_to_correct_pos(ClutterActor *listToScroll)
{
	gint slot;
	gfloat not_used, offset;

	ClutterAction *action = tangle_actor_get_action_by_type(listToScroll, TANGLE_TYPE_SCROLL_ACTION);
	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);

	slot = (gint)offset % (gint)listItemHeight < listItemHeight / 2 ? (gint)(offset) / listItemHeight  
							  		: (gint)(offset) / listItemHeight + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", (gfloat)(slot*listItemHeight), NULL);
}

gboolean helpdesk_add_question_to_list(gpointer data, int index)
{	
	message *msg = data;
	char topictitle[33];

	strncpy(topictitle, msg->title, 33);
	topictitle[29] = topictitle[30] = topictitle[31] = '.'; 
	topictitle[32] ='\0'; 

	ClutterActor *colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar13.png",NULL);
	ClutterActor *avatarImage = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_avatarbackground_small.png", NULL);

	ClutterActor *text = clutter_text_new_with_text("Comic Sans 20", topictitle);	
	ClutterActor *questionButton = tangle_button_new_with_background_actor(text);

	ClutterActor *commentButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
					"communitymenu/community_comment_icon.png", NULL));

	ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());

	if(avatarImage == NULL || colorbar == NULL || commentButton == NULL)
	{	
		printf(_("NULL Pointer Detected!\n"));
		return FALSE;	
	}

	if(listItemHeight == 0) listItemHeight = clutter_actor_get_height(avatarImage) + 1;

	clutter_actor_set_position(colorbar, 0, listItemHeight - 1);
	clutter_container_add_actor(listContainer, colorbar);		//Add components inside the container
	clutter_container_add_actor(listContainer, avatarImage);

	clutter_actor_set_position(questionButton, 60, 23);			
	clutter_container_add_actor(listContainer, questionButton);

	clutter_actor_set_position(commentButton, 690, 15);
	clutter_container_add_actor(listContainer, commentButton);

	g_signal_connect_swapped(CLUTTER_ACTOR(questionButton), "clicked", G_CALLBACK(helpdesk_show_question_view), 
						clutter_actor_get_parent(questionButton));

	g_signal_connect_swapped(CLUTTER_ACTOR(commentButton), "clicked", G_CALLBACK(helpdesk_show_question_view), 
						clutter_actor_get_parent(commentButton));

	clutter_container_add_actor(questionlist, CLUTTER_ACTOR(listContainer));

	if(index <= 5)
		clutter_actor_set_height(CLUTTER_ACTOR(questionlist), listItemHeight * (index+1));	
	else
		clutter_actor_set_height(CLUTTER_ACTOR(questionlist), listItemHeight * 5);		

	return TRUE;
}

void helpdesk_find_selected_actor(ClutterActor *actor)
{
	GList *children = clutter_container_get_children(questionlist); //Get list of actors

	int index = 0;
	
	while(children != NULL)
	{
		if(actor == children->data)
		{
			selectedQuestion = index;
			break;
		}

		children = children->next;

		index++;
	}

	g_list_free(children);
}
