#ifndef COMMUNITY_UTILITIES_H
#define COMMUNITY_UTILITIES_H


#include "../jammo.h"
#include "../../configure.h"
#include <libintl.h>
#include "../../gems/gems_profile_manager.h"

#define DESTROY_ACTOR(x) {if(x==0); else{clutter_actor_destroy(x); x = 0;}}
#define TEXT_COMMENT 1
#define VOICE_COMMENT 2
#define MAX_FILES_IN_DIR 50
#define MAX_FILE_NAME_LEN 60

typedef struct forum_msg {
	gint  index;
	gchar avatar[20];
	gchar sender[20];	
	gchar title[100];
	gchar time[17];
	gchar *msg;
	gchar filepath[150];
	int type;
}message;

typedef struct {
	ClutterActor *text;
	int lineCount;
	gulong handler_id;
}TextField;

typedef struct{
	char time[19];
}time_type;

typedef struct{
	ClutterActor *body;
	ClutterActor *hair;
	ClutterActor *head;
	ClutterActor *instrument;
}Avatar; 

void song_name_press_action(ClutterActor*);
void rename_loop(ClutterActor *loopName);
void play_selected_loop(gchar* loopName);
void show_song_label(ClutterActor*);
void show_music_video(ClutterActor*);
void clear_container(ClutterContainer*);
gboolean add_images_from_directory(const char* path, ClutterContainer *list, GCallback, int, int);
gboolean add_single_button(ClutterActor*, ClutterContainer*, char*, int, int, GCallback);
time_type get_current_time();
void limit_line_count(TextField *text);
void clear_messagelist(GList*);
gboolean community_get_avatar(Avatar*, guint32);
gboolean community_save_avatar(Avatar*);
int community_open_and_arrange_dir(char* path, char* suffix, char result[MAX_FILES_IN_DIR][MAX_FILE_NAME_LEN]);

#endif
