/**sequencer_track_view.c is part of JamMo.
License: GPLv2, read more from COPYING

Call this: sequencer_track_view_tune_width
 */
#include <glib-object.h>
#include <clutter/clutter.h>
#include <string.h>
#include <stdlib.h>
#include <tangle.h>


#include "../../meam/jammo-track.h"
#include "../../meam/jammo-editing-track.h"
#include "../../meam/jammo-instrument-track.h"
#include "../../meam/jammo-slider-track.h"
#include "../../meam/jammo-backing-track.h"
#include "../../meam/jammo-midi.h"
#include "../../meam/jammo-meam.h" //JAMMO_DURATION_INVALID

#include "../jammo-track-view.h"
#include "../jammo-editing-track-view.h"
#include "../jammo-miditrack-view.h"
#include "../jammo.h"
#include "../jammo-cursor.h"
#include "../save_helper.h"

#include "sequencer_track_view.h"
#include "sequencer.h"
#include "midi_editor.h"
#include "instrument_gui.h"
#include "jammer_view.h"
#include "startmenu.h"

#include "../../cem/cem.h"
static int width_of_slot = 40;




//We get these as parameters
static int number_of_slots = -1;

gboolean pressed_sequencer_button_mute (TangleButton *tanglebutton, gpointer user_data);
gboolean pressed_sequencer_button_volume (TangleButton *tanglebutton, gpointer user_data);
gboolean pressed_sequencer_button_track_label (TangleButton *tanglebutton, gpointer data);

//We want toggle this up, when next is clicked
TangleButton* last_pressed_volume_button = NULL;



/*
 * Event for pressing label on track, data points to track structure
 */
gboolean pressed_sequencer_button_track_label (TangleButton *tanglebutton, gpointer data) {
	ClutterActor* control_panel_for_this_track = clutter_actor_get_parent(CLUTTER_ACTOR(tanglebutton));
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(control_panel_for_this_track));
	TangleWidget* track_view;

	track_view = TANGLE_WIDGET(jammo_get_actor_by_id(name));
	if (track_view==NULL) {
		printf("Can't find what track is asked\n");
		return FALSE;
	}

	printf("Pressed track label\n");
	if (JAMMO_IS_MIDITRACK_VIEW(track_view))
	{
		printf("It is instrument track\n");
		//We can start realtime jamming or midi-editor.
		//Midi-editor backs always to sequencer.
		//From Jamming we can go back to sequencer or reach editor
		//TODO: some way to go straight to editor.

		//jamming
		instrument_gui_start(JAMMO_MIDITRACK_VIEW(track_view), NULL); //NULL means no slider

		//editor
		//midi_editor_start_with_miditrack_view(JAMMO_MIDITRACK_VIEW(track->track_view));
	}
	else if (JAMMO_IS_TRACK_VIEW(track_view))
	{
		printf("It is slider track or backing-track\n");
		TangleWidget* container2 = TANGLE_WIDGET(track_view);
		JammoTrack* track;
		g_object_get(track_view,"track",&track,NULL);
		if (JAMMO_IS_SLIDER_TRACK(track)) {
			printf(" it is slider_track\n");
			instrument_gui_start(NULL, container2); //NULL means no keyboard, but slider
		}
		else if (JAMMO_IS_BACKING_TRACK(track)){
			printf(" it is backing_track\n");
			clutter_actor_show(jammo_get_actor_by_id("backingtrack-selection-view"));
			clutter_actor_hide(jammo_get_actor_by_id("fullsequencer-view"));
		}
	}
	else if  (JAMMO_IS_EDITING_TRACK_VIEW(track_view)){
			printf(" it is editing_track (start jammer)\n");
			clutter_actor_show(jammo_get_actor_by_id("jammer-view"));
			clutter_actor_hide(jammo_get_actor_by_id("fullsequencer-view"));
			start_jammer();
		}

	return TRUE;
}


/*JSON callback. TODO
*/
gboolean fullsequencer_mentor_clicked (TangleButton *tanglebutton, gpointer data)   {
	printf("mentor clicked\n");
	return TRUE;
}

gboolean pressed_sequencer_button_mute (TangleButton *tanglebutton, gpointer data)   {
	ClutterActor* control_panel_for_this_track = clutter_actor_get_parent(CLUTTER_ACTOR(tanglebutton));
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(control_panel_for_this_track));
	printf("mute clicked: '%s'\n",name);
	TangleWidget* track_view;

	ClutterActor* container = jammo_get_actor_by_id("fullsequencer-container-for-tracks");
	track_view = TANGLE_WIDGET(tangle_widget_get_nth_child(TANGLE_WIDGET(container),atoi(name)));

	JammoPlayingTrack* jammotrack;

	//slider is inside tangle_widget, midi- and loop-tracks are inside of jammo-*track-view
	if (JAMMO_IS_EDITING_TRACK_VIEW(track_view) || JAMMO_IS_MIDITRACK_VIEW(track_view)  || JAMMO_IS_TRACK_VIEW(track_view) ) {
		g_object_get(track_view, "track", &jammotrack, NULL);
	} else if (TANGLE_IS_WIDGET(track_view)) {
		jammotrack = JAMMO_PLAYING_TRACK(g_object_get_data(G_OBJECT(track_view),"track"));
	} else  {
		return FALSE;
	}

	if (jammotrack)
		jammo_playing_track_set_muted(JAMMO_PLAYING_TRACK(jammotrack), tangle_button_get_selected(tanglebutton));

	return TRUE;
}



/**
This syncs scrollers offset to tracks volume.
*/
gboolean sequencer_volumebar_used (ClutterActor *scroll_action, gpointer none){
	//printf("sequencer_volumebar_used\n");
	if (!last_pressed_volume_button)
		return FALSE;

	ClutterActor* volume_scroller = clutter_actor_meta_get_actor(CLUTTER_ACTOR_META(scroll_action));
	//-50 is height of the visible marker.
	gfloat height = clutter_actor_get_height(CLUTTER_ACTOR(volume_scroller))-50;
	gfloat offset,not_used;
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(scroll_action), &not_used,&offset);

	JammoPlayingTrack* jammotrack = g_object_get_data(G_OBJECT(volume_scroller),"track");

	gfloat new_volume = offset/height; //This is between [0...1]
	if (jammo_playing_track_get_volume(jammotrack) == new_volume)
		return FALSE;

	jammo_playing_track_set_volume(jammotrack,new_volume);

	gchar* message = g_strdup_printf("Volume changed to %f",new_volume);
	cem_add_to_log(message,J_LOG_USER_ACTION);
	g_free(message);

	//These are for changing texture of volume-button
	ClutterActor* container = tangle_button_get_normal_background_actor(last_pressed_volume_button);
	ClutterActor* nub = tangle_widget_get_nth_child(TANGLE_WIDGET(container),0);

	ClutterActor* container2 = tangle_button_get_selected_background_actor(last_pressed_volume_button);
	ClutterActor* nub2 = tangle_widget_get_nth_child(TANGLE_WIDGET(container2),0);

	gfloat height_ = 36; //clutter_actor_get_height(container) - clutter_actor_get_height(nub); //If hided. container reports it's height wrongly
	//printf("height_: %f\n",height_);

	clutter_actor_set_y(nub,height_-new_volume*height_);
	clutter_actor_set_y(nub2,height_-new_volume*height_);
	return FALSE;
}



/**
Each tracks share one volumebar.
*/
gboolean pressed_sequencer_button_volume (TangleButton *tanglebutton, gpointer data) {

	ClutterActor* control_panel_for_this_track = clutter_actor_get_parent(CLUTTER_ACTOR(tanglebutton));
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(control_panel_for_this_track));
	printf("volume clicked: '%s'\n",name);
	TangleWidget* track_view;

	ClutterActor* container = jammo_get_actor_by_id("fullsequencer-container-for-tracks");
	track_view = TANGLE_WIDGET(tangle_widget_get_nth_child(TANGLE_WIDGET(container),atoi(name)));

	JammoPlayingTrack* jammotrack;

	ClutterActor* volume_container = jammo_get_actor_by_id("fullsequencer-volumebar-container");
	ClutterActor* volume_scroller = jammo_get_actor_by_id("fullsequencer-volumebar-scroller");
	ClutterAction* scroll_action = tangle_actor_get_action_by_type(volume_scroller,TANGLE_TYPE_SCROLL_ACTION);


	//slider and backingtrack is inside tangle_widget, midi- and loop-tracks are inside of jammo-*track-view
	if (JAMMO_IS_EDITING_TRACK_VIEW(track_view) || JAMMO_IS_MIDITRACK_VIEW(track_view)  || JAMMO_IS_TRACK_VIEW(track_view) ) {
		g_object_get(track_view, "track", &jammotrack, NULL);
	} else if (TANGLE_IS_WIDGET(track_view)) {
		jammotrack = JAMMO_PLAYING_TRACK(g_object_get_data(G_OBJECT(track_view),"track"));
	} else  {
		return FALSE;
	}

	gfloat current_volume = jammo_playing_track_get_volume(jammotrack);
	//printf("volume of this track is :%f\n",current_volume);

	//When pressing already selected track, hide volume bar
	if (last_pressed_volume_button==tanglebutton) {
		clutter_actor_hide(volume_container);
		g_object_set_data(G_OBJECT(volume_scroller),"track",NULL);
		last_pressed_volume_button=NULL;
	}

	//Hide last pressed and put new value to volumebar from track
	else {
		clutter_actor_show(volume_container);
		//-50 is height of the visible marker.
		gfloat new_place = (clutter_actor_get_height(CLUTTER_ACTOR(volume_scroller))-50)*current_volume;
		//printf("new place: %f\n",new_place);
		tangle_object_animate(G_OBJECT(scroll_action),  CLUTTER_EASE_IN_OUT_QUAD, 50, "offset-y", new_place, NULL);
		g_object_set_data(G_OBJECT(volume_scroller),"track",jammotrack);
		if (last_pressed_volume_button)
			tangle_button_set_selected(last_pressed_volume_button,FALSE);
		last_pressed_volume_button=tanglebutton;
		}

	return FALSE;
}




//JSON callback
void fullsequencer_on_cursor_notify_x(GObject* object, GParamSpec* param_spec, gpointer user_data) {
	//printf("fullsequencer_on_cursor_notify_x\n");

	ClutterActor* scrolling_view = jammo_get_actor_by_id("fullsequencer-container-for-tracks");
	ClutterAction* scroll_action = tangle_actor_get_action_by_type(scrolling_view,TANGLE_TYPE_SCROLL_ACTION);

	gfloat x, visible, offset, max;

	g_object_get(object, "x", &x, NULL);
	g_object_get(scrolling_view, "width", &visible, NULL);
	g_object_get(scroll_action, "offset-x", &offset, "max-offset-x", &max, NULL);
	//printf("x=%f, visible-width =%f, offset=%f, max=%f\n",x,visible,offset,max);

	if (x < offset) {
		offset = x - visible + 80.0;
		if (offset < 0.0) {
			offset = 0.0;
		}
		tangle_object_animate(G_OBJECT(scroll_action),  CLUTTER_EASE_IN_OUT_QUAD, 250, "offset-x", offset, NULL);
	} else if (x > offset + visible - 80.0) {
		offset += 160.0;
		if (offset > max) {
			offset = max;
		}
		tangle_object_animate(G_OBJECT(scroll_action),  CLUTTER_EASE_IN_OUT_QUAD, 250, "offset-x", offset, NULL);
	}
}

/***************************
Functions for json
**************************/



void fullsequencer_play_clicked (TangleButton* tanglebutton, gpointer none){
	printf("fullsequencer: Play-Stop-Button pressed\n");

	//tanglebutton is toggle-button.
	gboolean selected;
	g_object_get(tanglebutton, "selected", &selected,  NULL);

	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	if (selected) {
		jammo_sequencer_play(sequencer);
	}
	else {
		jammo_sequencer_stop(sequencer);
	}
}



//TODO
void fullsequencer_record_clicked (TangleButton* tanglebutton, gpointer none){
	printf("fullsequencer: Record pressed\n");
}



void fullsequencer_community_clicked (TangleButton* tanglebutton, gpointer none){
	printf("fullsequencer: Community pressed. Doesn't do anything\n");
}

void fullsequencer_home_clicked (TangleButton* tanglebutton, gpointer none){
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));

	jammo_sequencer_stop(sequencer);

	gchar* meta_data = g_strdup_printf
	("\"pitch\" : \"%s\",\n\"tempo\" : %d,\n",jammo_sequencer_get_pitch(sequencer),jammo_sequencer_get_tempo(sequencer));

	//save composition will return filename, but we are not interested in
//	g_free(save_composition("7-12/", jammo_get_actor_by_id("fullsequencer-container-for-tracks"),meta_data));
	g_free(meta_data);
	startmenu_goto_startmenu(NULL,NULL);
}


/*
Also prepare cursor.
*/
void sequencer_track_view_tune_width() {
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	guint64 duration;
	duration = jammo_sequencer_get_duration(sequencer);

	g_print("Duration: %" G_GUINT64_FORMAT "\n", duration);

	gint tempo_factory = 4;
	//We want operate whole time with guint64.
	guint64 temp=60*tempo_factory;
	guint64 one_second = 1000000000L;
	guint64 big = temp * one_second;
	guint64 duration_of_one_slot = big / jammo_sequencer_get_tempo(sequencer);

	gint n_slots = duration/duration_of_one_slot;
	printf("*number_of_slots (in backing-track / for editing-track): %d\n",n_slots);


	//Set static
	number_of_slots = n_slots;

	//CURSOR
	gfloat width_of_area = number_of_slots*width_of_slot;
	ClutterActor* cursor;
	cursor = jammo_get_actor_by_id("fullsequencer_cursor");
	if (cursor)
		clutter_actor_set_size(cursor, width_of_area, 80.0); //width is important, height is not used
}

