/*
 * welcome.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */
#include <tangle.h>
#include <clutter/clutter.h>

#include "../../configure.h"
#include "../jammo.h"
#include "../../meam/jammo-sample.h"
#include "chum.h"

#include "../pen_gesture/login_screen.h"



static void finalize_welcome(void) {
	ClutterActor* actor;

	if ((actor = jammo_get_actor_by_id("welcome-view"))) {
		tangle_actor_hide_animated(TANGLE_ACTOR(actor));
	}

	//Do not go to main-menu, but login_screen
	login_screen();
	/*
	if ((actor = jammo_get_actor_by_id("main-menu-view"))) {
		clutter_actor_show(actor);
		clutter_actor_queue_relayout(clutter_actor_get_parent(actor));
	}
	*/

	//Set default language for singing game
	// It also affects first flag showed
	gchar* lang = getenv ("LANG");
	//printf("LANG='%s'\n",lang);

	gchar* lang2 = g_strndup (lang,2); //two characters are enough
	gchar* lang3 = g_strdup_printf("_%s",lang2);
	chum_set_selected_language(lang3);
	g_free(lang2);
	g_free(lang3);
}


/*
If user doesn't click door, there are timeout. Timeout calls welcome_door_clicked, but action==NULL.
All this hazzling is needed because user can click (or double click) very same time than timeout triggers.
*/
static gboolean door_is_opening = FALSE; //Or opened already.
void welcome_door_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	if (door_is_opening && action == NULL)
		return;

	door_is_opening = TRUE;
	ClutterActor* actor;
	ClutterAnimation* animation;
	ClutterTimeline* timeline;
	gchar* filename;
	JammoSample* sample;

	actor = jammo_get_actor_by_id("welcome-door");
	g_assert(actor != NULL);
	
	if ((animation = clutter_actor_get_animation(actor))) {
		clutter_animation_completed(animation);
		jammo_sample_stop_all();
		finalize_welcome();
	} else {
		animation = clutter_actor_animate(actor, CLUTTER_LINEAR, 2750, "rotation-angle-y", -110.0, NULL);

		timeline = clutter_animation_get_timeline(animation);
		clutter_timeline_add_marker_at_time(timeline, "show-main-menu-view", 1750);
		g_signal_connect(timeline, "marker-reached::show-main-menu-view", G_CALLBACK(finalize_welcome), NULL);
		
		filename = g_strdup_printf("%s/door_opening.wav",DATA_DIR);
		sample = jammo_sample_new_from_file(filename);
		g_free(filename);
		jammo_sample_play(sample);
		g_object_unref(sample);
	}

	//Show version number: defined in configure.ac
	gchar* version = g_strdup_printf("JamMo version:%s",VERSION);
	ClutterActor* version_label = clutter_text_new_with_text ("Luxi Mono 38",version);
	ClutterColor text_color = { 255, 255, 0, 255 };
	clutter_text_set_color(CLUTTER_TEXT(version_label), &text_color);
	g_free(version);
	actor = jammo_get_actor_by_id("welcome-view");
	clutter_container_add_actor (CLUTTER_CONTAINER (actor), version_label);

}

