/** cem.c is part of JamMo.
License: GPLv2, read more from COPYING

(from D2.4)
CEM is started as JamMo is started as it is used to log user actions in
all use cases. Mentor and games components only need to be started if
the use case is correct.
*/
#include <stdio.h>
#include "cem.h"
#include <glib.h>


static int log_level=LOG_NONE; //Default.

void cem_set_log_level(int new_level) {
	log_level=new_level;
}

void cem_append_to_log_level(int level){
	if (!(level & log_level)) //Not yet, so add
	log_level+=level;
}


static gchar* type_to_word(int type) {
GString* string = g_string_new("");

if (type & LOG_DEBUG)
	string = g_string_append(string,"DEBUG ");
if (type & LOG_INFO)
	string = g_string_append(string,"INFO ");
if (type & LOG_FATAL)
	string = g_string_append(string,"FATAL ");
if (type & LOG_ERROR)
	string = g_string_append(string,"ERROR ");
if (type & LOG_WARN)
	string = g_string_append(string,"WARN ");
if (type & LOG_USER_ACTION)
	string = g_string_append(string,"USER ");
if (type & LOG_NETWORK)
	string = g_string_append(string,"NETWORK ");
if (type & LOG_NETWORK_DEBUG)
	string = g_string_append(string,"NETWORK_DEBUG ");

return g_string_free (string, FALSE);
}


static void get_time(char timestamp_now[]) {
	time_t rawtime;
	struct tm * timeinfo;
	time ( &rawtime );
	timeinfo = localtime ( &rawtime );
	strftime (timestamp_now,80,"%Y.%m.%d_%H.%M.%S",timeinfo);
}

/*
No need to add linebreaks.
Usage:
cem_add_to_log("error_message",LOG_ERROR);
or
cem_add_to_log("fatal+info_message",LOG_FATAL+LOG_INFO);
*/
void cem_add_to_log(char *message,int type){
	gchar* name;
	if (type & log_level) { //We are interedted this kind of log-message
		name=type_to_word(type);
		char timestamp [80];
		get_time(timestamp);
		printf("*%s %s: '%s' :%s*\n",timestamp, name,message,name);
		g_free(name);
	}

}
