/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */
#include <tangle.h>
#include <glib-object.h>
#include "startmenu.h"
#include "../jammo.h"
#include "../jammo-game-level.h"
#include "sequencer.h"
#include "gamesmenu.h"
#include "communitymenu.h"

#include "../../cem/cem.h"

void startmenu_goto_sequencer (TangleButton* tanglebutton, gpointer none){
	printf("startmenu_goto_sequencer\n");
	clutter_actor_hide(jammo_get_actor_by_id("startmenu-view"));
	//tangle_view_unload(TANGLE_VIEW(jammo_get_actor_by_id("startmenu-view"))); //TODO: enable when fixed on upstream


	clutter_actor_show (jammo_get_actor_by_id("fullsequencer-view")); //contains only templates (show works better than load_now() )

	//We want find "game-level" and it is defined on "levelX-view"
	tangle_view_load_now(TANGLE_VIEW(jammo_get_actor_by_id("level3-view")));
	jammo_game_level_start_task(JAMMO_GAME_LEVEL(jammo_get_object_by_id("game-level")),"level3-task1.json");  //TODO: level1000-view (last-level)

	clutter_actor_show(jammo_get_actor_by_id("level3-view"));
	start_sequencer_full_sequencer(NULL,NULL,NULL,NULL); //FIXME: this was previously called when fullscreen-view is showed
}

void startmenu_goto_gamesmenu (TangleButton* tanglebutton, gpointer none){
	printf("startmenu_goto_gamesmenu\n");
	start_gamesmenu();
}

void startmenu_goto_communitymenu(TangleButton* tanglebutton, gpointer none){
	printf("startmenu_goto_communitymenu\n");
	start_communitymenu();

}

void startmenu_mentor_clicked(TangleButton* tanglebutton, gpointer none){
	printf("startmenu_mentor_clicked\n");
}

void startmenu_left_arrow_clicked(TangleButton* tanglebutton, gpointer none){
	printf("startmenu_left_arrow_clicked\n");
	ClutterActor* scroller = jammo_get_actor_by_id( "startmenu-scroller");
	float old_value;
	g_object_get(scroller, "scrolling-offset-x", &old_value, NULL);
	clutter_actor_animate(scroller, CLUTTER_EASE_IN_OUT_QUAD, 250,"scrolling-offset-x",old_value+250, NULL);
}
void startmenu_right_arrow_clicked(TangleButton* tanglebutton, gpointer none){
	printf("startmenu_right_arrow_clicked\n");
	ClutterActor* scroller = jammo_get_actor_by_id( "startmenu-scroller");
	float old_value;
	g_object_get(scroller, "scrolling-offset-x", &old_value, NULL);
	clutter_actor_animate(scroller, CLUTTER_EASE_IN_OUT_QUAD, 250,"scrolling-offset-x",old_value-250, NULL);
}


void startmenu_draw_version_information(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	//Show version number: defined in configure.ac
	gchar* version = g_strdup_printf("Version-%s",VERSION);
	ClutterActor* version_label = clutter_text_new_with_text ("Luxi Mono 36",version);
	ClutterColor text_color = { 255, 255, 0, 255 };
	clutter_actor_set_x(version_label,10.0);
	clutter_text_set_color(CLUTTER_TEXT(version_label), &text_color);
	g_free(version);
	ClutterActor* actor = jammo_get_actor_by_id("startmenu-view");
	clutter_container_add_actor (CLUTTER_CONTAINER (actor), version_label);

	/* //Doesn't work. startmenu-version-info is not loaded when this funtion is called
	ClutterActor* text_actor = jammo_get_actor_by_id( "startmenu-version-info");
	gchar* version = g_strdup_printf("Version-%s",VERSION);
	clutter_text_set_text(CLUTTER_TEXT(text_actor), version);
	g_free(version);
	*/
}

void startmenu_quit (TangleButton* tanglebutton, gpointer none){
	cem_add_to_log("startmenu_quit-called",LOG_USER_ACTION);
	clutter_main_quit();
}

/*
Whenever any view want return back to startmenu, this function can be used
*/
void startmenu_goto_startmenu (TangleButton* tanglebutton, gpointer none){
	cem_add_to_log("startmenu_goto_startmenu-called",LOG_USER_ACTION);
	tangle_view_unload(TANGLE_VIEW(jammo_get_actor_by_id("fullsequencer-view")));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	clutter_actor_show(jammo_get_actor_by_id("startmenu-view"));
}

