#include <tangle.h>
#include <glib-object.h>
#include "gamesmenu.h"
#include "startmenu.h"
#include "../jammo.h"

#include "../jammo-game-task.h"
#include "../jammo-game-level.h"
#include "../jammo-game-level-view.h"


#include "../jammo-mentor.h"
#include "../jammo-editing-track-view.h"
#include "../jammo-miditrack-view.h"
#include "../../cem/cem.h"

#include "sequencer.h"

static void demo_for_task1(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer);
static void to_task1(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer);
static void task1_completed(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer);

//Functions for whole level
//This triggers very same time than last task-completed
void level1_completed(JammoGameLevel* game_level) {
	g_print("MENTOR: All task on level1 completed -> Level1 completed\n");
}



///////////////
//Task specific
///////////////

//Task1: listening four rhythmic loops
void level1_task1_started(JammoGameTask* task) {
	g_print("MENTOR: Lets_rock.\n");
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "lets_rock.spx",demo_for_task1,NULL);
}

void level1_task1_on_act_completed(JammoGameTask* task, const gchar* act_name, guint acts_completed) {
	gint act_left;

	act_left = (gint)jammo_game_task_get_acts_to_complete(task) - (gint)acts_completed;
	if (act_left > 0) {
		if (act_left > 2 ) {
			jammo_mentor_speak(jammo_mentor_get_default(), "listen_another.spx three.spx rhythmloopB.spx");
		}
		else if (act_left > 1 ) {
			jammo_mentor_speak(jammo_mentor_get_default(), "listen_another.spx two.spx rhythmloopB.spx");
		}
		else
			jammo_mentor_speak(jammo_mentor_get_default(), "listen_another.spx one.spx rhythmloop.spx");
		g_print("MENTOR: Good! Listen %u more loops.\n", act_left);
	}
}

void level1_task1_on_act_redone(JammoGameTask* task, const gchar* task_name, guint tasks_completed) {
	jammo_mentor_speak(jammo_mentor_get_default(), "listen_to_different.spx");
	g_print("MENTOR: You had already listened this loop. Try another!\n");
}

void level1_task1_completed(JammoGameTask* task) {
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "fine_found_rhythms.spx", task1_completed, NULL);
	g_print("MENTOR: Excellent! Now you have accomplished level1-task1. Please, proceed.\n");
}

//This is assigned on c-file
void level1_sample_button_on_wheel_listened(JammoSampleButton* sample_button, JammoGameTask* task) {
	gchar* name = g_strdup_printf("%d",jammo_sample_button_get_loop_id(sample_button));
	jammo_game_task_set_act_completed(task,name, TRUE);
	g_free(name);
}


static void to_task1(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer){
	jammo_mentor_speak(jammo_mentor_get_default(), "your_turn.spx");
}

static void demo_for_task1(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer){
	sequencer_change_to_loop_view(NULL,NULL);
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "listen_different.spx rhythmloops.spx", to_task1, NULL);
	g_print("MENTOR demo to task! TODO\n"); //TODO
}

static void task1_completed(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer){
	sequencer_change_to_sequencer_view(NULL,NULL);
	jammo_game_level_start_next_task(JAMMO_GAME_LEVEL(jammo_get_object_by_id("game-level")));
}
//Task1 over


//Task2
static void task2_on_sequencer_stopped(JammoSequencer* sequencer, gpointer user_data){
	JammoGameTask* task = JAMMO_GAME_TASK(jammo_get_object_by_id("level1-task2.json"));
	jammo_game_task_set_act_completed(task,"backing_track_listened", TRUE);
}

static void to_task2(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer data){
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	g_signal_connect(sequencer, "stopped", G_CALLBACK(task2_on_sequencer_stopped),NULL);
	jammo_sequencer_play(sequencer);
}


void level1_task2_started(JammoGameTask* task) {
	g_print("MENTOR: Listen backing track\n");
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "listen_backing_track1.spx", to_task2, NULL);
}

void level1_task2_on_act_completed(JammoGameTask* task, const gchar* act_name, guint acts_completed) {
	g_print("MENTOR: Act completed\n");
	jammo_mentor_speak(jammo_mentor_get_default(), "greatB.spx");
}

void level1_task2_completed(JammoGameTask* task) {
	g_print("MENTOR: Excellent! Now you have accomplished level1-task2. Please, proceed.\n");
}


