/*
 * data_structs.h
 *
 *  Created on: 2009-10-05
 *      Author: marcin
 */

#ifndef DATA_STRUCTS_H_
#define DATA_STRUCTS_H_

#include <glib.h>
#include <libxml/tree.h>

extern int G_TYPE_ALBUM;
extern int G_TYPE_RADIO;

void data_structs_type_register();

/*
 * unit Album
 */
typedef struct _Album {
	/**
	 * numeric id of the album
	 */
	gint id;

	/**
	 * link to the cover of the album
	 */
	gchar* image;

	/**
	 * name of the album
	 */
	gchar* name;

	/**
	 * Rating of the album
	 */
	gdouble rating;

	/**
	 * Display name of the artist.
	 */
	gchar* artist_name;
} Album;

Album* album_new();

Album* album_new_from_xml(xmlNode* album_node);

Album* album_copy(Album* album);

void album_set_id(Album* album, const gint id);

void album_set_image(Album* album, const gchar* image);

gchar* album_get_image(Album* album, gint size);

void album_set_name(Album* album, const gchar* name);

void album_set_rating(Album* album, const gdouble rating);

void album_set_artist_name(Album* album, const gchar* artist_name);

void album_free(Album* album);

void album_dump(Album* album);

void album_list_free(GList* album_list);

/*
 * unit Track
 */

typedef struct _Track {
	gint id;
	gchar* name;
	gint duration;
	gchar* stream;
	gdouble rating;
	gint artist_id;
	gchar* artist_name;
	gint album_id;
	gchar* album_name;
} Track;

Track* track_new();

Track* track_new_from_xml(xmlNode* track_node);

void track_free(Track* track);

void track_set_id(Track* track, const gint id);

void track_set_name(Track* track, const gchar* name);

void track_set_duration(Track* track, const gint duration);

void track_set_stream(Track* track, const gchar* stream);

void track_set_rating(Track* track, const gdouble rating);

void track_set_artist_id(Track* track, const gint artist_id);

void track_set_artist_name(Track* track, const gchar* artist_name);

void track_set_album_id(Track* track, const gint album_id);

void track_set_album_name(Track* track, const gchar* album_name);

void track_list_free(GList* track_list);

/*
 * unit Radio
 */
typedef struct _Radio {
	gint id;
	gchar* name;
	gchar* image;
} Radio;

Radio* radio_new();

Radio* radio_copy(Radio* radio);

Radio* radio_new_from_xml(xmlNode* radio_node);

void radio_free(Radio* radio);

void radio_set_id(Radio* radio, const gint id);

void radio_set_name(Radio* radio, const gchar* name);

void radio_set_image(Radio* radio, const gchar* image);

void radio_list_free(GList* radio_list);

#endif /* DATA_STRUCTS_H_ */
