#ifndef _UT_REMOTEDBMGR_H_
#define _UT_REMOTEDBMGR_H_

#include <QObject>
#include <QWaitCondition>
#include <QMutex>
#include <QDomDocument>

#include "remotedb.h"
#include "remotedbmgr.h"

class Ut_RemoteDBMgr : public QObject
{
    Q_OBJECT

private slots:
    void initTestCase();
    void cleanupTestCase();
    void testGetDBAsync();

public slots: // public slots are not called by Qt Test framework
    void verifyDB(RemoteDB *db);

private:
    void createTestData();
    void createTestDocument();
    void createMfgElements(QChar &letter, QDomElement &parent);
    void createModelElements(const QString &mfg, QDomElement &parent);
    void verifyRemotes(RemoteDB *db);

private:
    RemoteDBMgr *subject;
    QWaitCondition dbVerified;
    QMutex dbMutex;
    RemoteDB validDB;
    bool dbOk;
    QDomDocument document;

};

#endif // _UT_REMOTEDBMGR_H_


