#include "ut_onlinepollerthread.h"
#include "onlinepollerthread.h"

// stubs
#include <QNetworkConfigurationManager>
#include <QDBusConnection>

#include <QtTest>
#include <QSignalSpy>


void Ut_OnlinePollerThread::initTestCase()
{
}

void Ut_OnlinePollerThread::cleanupTestCase()
{
}

void init()
{
    QDBusConnection::sentMessages.clear();
}

void Ut_OnlinePollerThread::testRunOnline()
{
    OnlinePollerThread thread;
    QNetworkConfigurationManager::online = true;
    QSignalSpy spy(&thread, SIGNAL(online()));
    thread.start();
    QTest::qWait(500);
    thread.stop();
    
    QCOMPARE(spy.count(), 1);
    QCOMPARE(QDBusConnection::sentMessages.size(), 0);
}

void Ut_OnlinePollerThread::testRunOffline()
{
    OnlinePollerThread thread;
    QNetworkConfigurationManager::online = false;
    QSignalSpy spy(&thread, SIGNAL(online()));
    thread.start();
    QTest::qWait(500);
    thread.stop();

    QCOMPARE(spy.count(), 0);
    QCOMPARE(QDBusConnection::sentMessages.size(), 1);

    QCOMPARE(QDBusConnection::sentMessages[0].service(),
            QString("com.nokia.icd_ui"));
    QCOMPARE(QDBusConnection::sentMessages[0].path(),
            QString("/com/nokia/icd_ui"));
    QCOMPARE(QDBusConnection::sentMessages[0].interface(),
            QString("com.nokia.icd_ui"));
    QCOMPARE(QDBusConnection::sentMessages[0].member(),
            QString("show_conn_dlg"));

    QCOMPARE(QDBusConnection::sentMessages[0].arguments().size(), 1);
}

QTEST_MAIN(Ut_OnlinePollerThread)

