#ifndef _QDBUSMESSAGE_H_
#define _QDBUSMESSAGE_H_

#include <QString>
#include <QVariant>
#include <QVector>

class QDBusMessage
{
public:
    QDBusMessage();
    QDBusMessage(const QDBusMessage &);

    static QDBusMessage createMethodCall(const QString &service,
                                         const QString &path,
                                         const QString &interface,
                                         const QString &method);
    QString service();
    QString path();
    QString interface();
    QString member();
    QDBusMessage &operator<<(const QVariant arg);
    QVector<QVariant> &arguments();

private:
    QDBusMessage(const QString &service,
                 const QString &path,
                 const QString &interface,
                 const QString &method);

private:
    QString m_service;
    QString m_path;
    QString m_interface;
    QString m_method;
    QVector<QVariant> m_arguments;
};

#endif // _QDBUSMESSAGE_H_

