#include <QResizeEvent>
#include <QHeaderView>
#include <QPixmap>
#include <QLabel>
#include <QWidget>
#include <QSettings>

#include "remotetable.h"
#include "remote.h"

RemoteTable::RemoteTable(QWidget *parent)
      // Always two columns: Remote name and rating.
    : QTableWidget(0, 2, parent)
{
    verticalHeader()->setVisible(false);
    horizontalHeader()->setVisible(false);
    
    setSelectionMode(QAbstractItemView::SingleSelection);
}

RemoteTable::~RemoteTable()
{
}

QWidget *RemoteTable::selectRatingWidget(int rating)
{
    QSettings settings;
    QLabel *label = new QLabel;
    QPixmap pix;
    if (rating < -45) {
        pix = QPixmap(settings.value("symbolPath", "/usr/share/irwi/symbols/").toString() + "down_5_thumbs.png");
    } else if (rating < -25) {
        pix = QPixmap(settings.value("symbolPath", "/usr/share/irwi/symbols/").toString() + "down_4_thumbs.png");
    } else if (rating < -12) {
        pix = QPixmap(settings.value("symbolPath", "/usr/share/irwi/symbols/").toString() + "down_3_thumbs.png");
    } else if (rating < -5) {
        pix = QPixmap(settings.value("symbolPath", "/usr/share/irwi/symbols/").toString() + "down_2_thumbs.png");
    } else if (rating < 0) {
        pix = QPixmap(settings.value("symbolPath", "/usr/share/irwi/symbols/").toString() + "down_1_thumbs.png");
    } else if (rating == 0) {
        pix = QPixmap(settings.value("symbolPath", "/usr/share/irwi/symbols/").toString() + "0_thumbs.png");
    } else if (rating < 5) {
        pix = QPixmap(settings.value("symbolPath", "/usr/share/irwi/symbols/").toString() + "up_1_thumbs.png");
    } else if (rating < 12) {
        pix = QPixmap(settings.value("symbolPath", "/usr/share/irwi/symbols/").toString() + "up_2_thumbs.png");
    } else if (rating < 25) {
        pix = QPixmap(settings.value("symbolPath", "/usr/share/irwi/symbols/").toString() + "up_3_thumbs.png");
    } else if (rating < 45) {
        pix = QPixmap(settings.value("symbolPath", "/usr/share/irwi/symbols/").toString() + "up_4_thumbs.png");
    } else {
        pix = QPixmap(settings.value("symbolPath", "/usr/share/irwi/symbols/").toString() + "up_5_thumbs.png");
    }

    label->setPixmap(pix);
    return label;
}

void RemoteTable::addItem(Remote *remote)
{
    if (remote == NULL) {
        return;
    }
    int currentRow = rowCount(); 
    remotes[currentRow] = remote;

    QString key = remote->name();
    QWidget *ratingWidget = selectRatingWidget(remote->rating());
    QTableWidgetItem *k = new QTableWidgetItem(key);
    k->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
    insertRow(currentRow);
    setItem(currentRow, 0, k);
    setCellWidget(currentRow, 1, ratingWidget);
    verticalHeader()->resizeSection(currentRow, 60);
}

Remote *RemoteTable::selected()
{
    QModelIndexList selections = selectedIndexes();
    if (selections.count() != 1) {
        return NULL;
    }

    return remotes[selections[0].row()];
}

void RemoteTable::removeAllRows()
{
    clear();
    setRowCount(0);
    remotes.clear();
}

void RemoteTable::resizeEvent(QResizeEvent *e)
{
    setColumnWidth(0, e->size().width() - 148);
    setColumnWidth(1, 128);
}
