#ifndef IRCTRL_H
#define IRCTRL_H

#include <QObject>
#include <QString>
#include <QTimer>

class IrCtrl : public QObject
{
    Q_OBJECT

public:
    explicit IrCtrl(QObject *parent = 0);
    ~IrCtrl();

public slots:
    void sendCmd(const QString &cmd);

    void stopLirc();
private:
    void startLirc();

private:
    QTimer m_killLircTimer;
    static const quint16 LIRC_PORT = 8765;
};

#endif

