#include "qnetworkreply.h"
#include "ut_remotedbmgr.h"

#include <QtTest>
#include <QNetworkAccessManager>

void Ut_RemoteDBMgr::initTestCase()
{
    dbOk = false;
    connect(&subject, SIGNAL(dbReady(RemoteDB *)),
            this, SLOT(verifyDB(RemoteDB *)));
    createTestData();
}

void Ut_RemoteDBMgr::cleanupTestCase()
{
}

void Ut_RemoteDBMgr::createTestData()
{
    RemoteList ra;
    ra << new Remote("model_A1", "A_mfg", 1, 9)
       << new Remote("model_A2", "A_mfg", 2, 10);
    RemoteList rb;
    rb << new Remote("model_B3", "B_mfg", 3, 11)
       << new Remote("model_B4", "B_mfg", 4, 12)
       << new Remote("model_B5", "B_mfg", 5, 13);
    RemoteList rc1;
    rc1 << new Remote("model_C1_6", "C1_mfg", 6, 14);
    RemoteList rc2;
    rc2 << new Remote("model_C2_7", "C2_mfg", 7, 15)
        << new Remote("model_C2_8", "C2_mfg", 8, 16);

    MfgMap ma;
    ma.insert("A_mfg", ra);
    MfgMap mb;
    mb.insert("B_mfg", rb);
    MfgMap mc;
    mc.insert("C1_mfg", rc1);
    mc.insert("C2_mfg", rc2);

    validDB.insert("A", ma);
    validDB.insert("B", mb);
    validDB.insert("C", mc);

    createTestDocument();
}

void Ut_RemoteDBMgr::createTestDocument()
{
    QDomElement root = document.createElement("db");
    document.appendChild(root);

    for (int i = 0; i < validDB.keys().size(); ++i) {
        QChar letter = validDB.keys()[i][0];
        QDomElement charEl = document.createElement("char");
        charEl.setAttribute("id", letter); 
        createMfgElements(letter, charEl);
        root.appendChild(charEl);
    }

    QNetworkReply::data.setData(document.toByteArray());
}

void Ut_RemoteDBMgr::createMfgElements(QChar &letter, QDomElement &parent)
{
    for (int i = 0; i < validDB[letter].keys().size(); ++i) {
        QString mfg = validDB[letter].keys()[i];
        QDomElement mfgEl = document.createElement("mfg");
        mfgEl.setAttribute("id", mfg);
        createModelElements(mfg, mfgEl);
        parent.appendChild(mfgEl);
    }
}

void Ut_RemoteDBMgr::createModelElements(const QString &mfg,
                                         QDomElement &parent)
{
    for (int i = 0; i < validDB[mfg[0]][mfg].size(); ++i) {
        Remote *r = validDB[mfg[0]][mfg][i];
        QDomElement modelEl = document.createElement("model");
        modelEl.setAttribute("name", r->name());
        modelEl.setAttribute("rating", r->rating());
        modelEl.setAttribute("vote_count", r->voteCount());
        parent.appendChild(modelEl);
    }
}

void Ut_RemoteDBMgr::testGetDBAsync()
{
    subject.getDBAsync();
    dbMutex.lock();
    dbVerified.wait(&dbMutex, 5000);  
    QCOMPARE(dbOk, true);
    dbMutex.unlock();
}

void Ut_RemoteDBMgr::verifyDB(RemoteDB *db)
{
    if (db == NULL) {
        dbOk = false;
    } else {
        QCOMPARE(db->isEmpty(), false);
        QCOMPARE(validDB.size(), db->size());
        verifyRemotes(db);
        dbOk = true;
    }
    dbVerified.wakeAll();
}

void Ut_RemoteDBMgr::verifyRemotes(RemoteDB *db)
{
    for (int i = 0; i < validDB.size(); ++i) {
        MfgMap &validMfgs = validDB[validDB.keys()[i]];
        MfgMap &mfgs = (*db)[db->keys()[i]];
        QCOMPARE(validMfgs.size(), mfgs.size());
        QCOMPARE(validDB.keys()[i], db->keys()[i]);
            
        for (int j = 0; j < validMfgs.size(); ++j) {
            RemoteList validRemotes = validMfgs[validMfgs.keys()[j]];
            RemoteList remotes = mfgs[mfgs.keys()[j]];
            QCOMPARE(validRemotes.size(), remotes.size());
            QCOMPARE(validMfgs.keys()[j], mfgs.keys()[j]);

            for (int k = 0; k < validRemotes.size(); ++k) {
                QCOMPARE(*(validRemotes[k]), *(remotes[k]));
            }
        }
    }
}


QTEST_MAIN(Ut_RemoteDBMgr)


