#include <QListWidget>
#include <QPixmap>
#include <QColor>

#include "remotelistwidgetitem.h"

RemoteListWidgetItem::RemoteListWidgetItem(Remote *remote, QListWidget *parent)
    : QListWidgetItem(parent, 1337), m_remote(remote)
{
    setFlags(Qt::NoItemFlags|Qt::ItemIsSelectable|Qt::ItemIsEnabled);
}

//overrides QListWidgetItem::data
QVariant RemoteListWidgetItem::data(int role) const
{
    QString str = m_remote->name() 
        + " (" + QString::number(m_remote->rating()) + ")";
    QPixmap pix = QPixmap(48,48);
    pix.fill(Qt::red);
    switch (role) {
        case Qt::DisplayRole:
            return QVariant(str);
        case Qt::DecorationRole:
            return QVariant(pix);
        default:
            return QVariant();
    }
}

