#include "onlinepollerthread.h"
#include <QNetworkConfigurationManager>
#include <QDBusMessage>
#include <QDBusConnection>

OnlinePollerThread::OnlinePollerThread()
    : m_exiting(false)
{
}

OnlinePollerThread::~OnlinePollerThread()
{
    m_exiting = true;
    stop();
    quit();
    wait();
}

void OnlinePollerThread::run()
{
    m_running = true;
    QTM_PREPEND_NAMESPACE(QNetworkConfigurationManager) qncm;
    bool connected = qncm.isOnline();
    if (!connected) {
        QDBusMessage m = QDBusMessage::createMethodCall(
                "com.nokia.icd_ui", "/com/nokia/icd_ui", 
                "com.nokia.icd_ui", "show_conn_dlg");
        m << false;
        QDBusConnection::systemBus().send(m);
        while(m_running)
        {
            connected = qncm.isOnline();
            if (connected) {
                m_running = false;
            } else {
                msleep(250);
            }
        }
    }

    if (connected) {
        emit online();
    }

    if (!m_exiting) {
        exec();
    }
}

void OnlinePollerThread::stop()
{
    m_running = false;
}

