#include <QSettings>
#include "ut_remote.h"
#include "rating.h"
#include <QNetworkReply>
#include "qnetworkaccessmanager.h"

#include <QtTest>
#include <QDebug>
#include <QMutex>


#define private public
#include "remote.h"
#undef private

void reset()
{
    QNetworkAccessManager::urls.clear();
    QSettings::values.clear();
    QNetworkReply::data.close();
    QNetworkReply::data.setData("");
}

void Ut_Remote::initTestCase()
{
    subject = NULL;
}

void Ut_Remote::cleanupTestCase()
{
}

void Ut_Remote::init()
{
    subject = new Remote();
    reset();
}

void Ut_Remote::cleanup()
{
    if (subject != NULL) {
        delete subject;
        subject = NULL;
    }
    reset();
}

void Ut_Remote::testSaveToFile_normal()
{
    connect(subject, SIGNAL(saveFinished()),
            this, SLOT(wakeTest()));
    subject->m_name = "testname";
    QSettings settings;
    settings.setValue("lircConf", "/tmp/irwiTestLircConf");
    QNetworkReply::data.close();
    QNetworkReply::data.setData("testdata");
    QNetworkReply::data.open(QIODevice::ReadOnly);

    subject->saveToFile();

    //wait for signal
    QMutex mutex;
    mutex.lock();
    cond.wait(&mutex, 1000);
    mutex.unlock();

    QCOMPARE(QNetworkAccessManager::urls.count(), 1);
    QCOMPARE(QNetworkAccessManager::urls[0], 
            QString("http://mercury.wipsl.com/irwi/uploaded/testname"));
    QCOMPARE(settings.value("remoteName", "fail").toString(), 
            QString("testname"));
    QFile f("/tmp/irwiTestLircConf");
    f.open(QIODevice::ReadOnly);
    QByteArray testData = f.readAll();
    f.close();
    QCOMPARE(testData, QNetworkReply::data.data());
}

void Ut_Remote::testSaveToFile_emptyname()
{
    subject->m_name = "";
    subject->saveToFile();
    QCOMPARE(QNetworkAccessManager::urls.count(), 0);
    QSettings settings;
    QCOMPARE(settings.value("remoteName", "testname").toString(), 
            QString("testname"));
}

void Ut_Remote::testUpdateInfo_normal()
{
    connect(subject, SIGNAL(infoUpdated()),
            this, SLOT(wakeTest()));
    subject->m_name = "testname";
    QNetworkReply::data.close();
    QNetworkReply::data.setData("1\n2\ntestmfg\n");
    QNetworkReply::data.open(QIODevice::ReadOnly);
    subject->updateInfo();

    //wait for signal
    QMutex mutex;
    mutex.lock();
    cond.wait(&mutex, 1000);
    mutex.unlock();

    QCOMPARE(QNetworkAccessManager::urls.count(), 1);
    QCOMPARE(QNetworkAccessManager::urls[0], 
            QString("http://mercury.wipsl.com/irwi/vote/get?name=testname"));
    QCOMPARE(subject->rating(), 1);
    QCOMPARE(subject->voteCount(), 2);
    QCOMPARE(subject->mfg(), QString("testmfg"));
}

void Ut_Remote::testUpdateInfo_emptyname()
{
    subject->m_name = "";
    subject->updateInfo();
    QCOMPARE(QNetworkAccessManager::urls.count(), 0);
}

void Ut_Remote::testSendRating_up()
{
    subject->m_name = "testname";
    subject->sendRating(Rating::Up);
    QCOMPARE(QNetworkAccessManager::urls.count(), 1);
    QCOMPARE(QNetworkAccessManager::urls[0], 
            QString("http://mercury.wipsl.com/irwi/vote/up?name=testname"));
}

void Ut_Remote::testSendRating_down()
{
    subject->m_name = "testname";
    subject->sendRating(Rating::Down);
    QCOMPARE(QNetworkAccessManager::urls.count(), 1);
    QCOMPARE(QNetworkAccessManager::urls[0], 
            QString("http://mercury.wipsl.com/irwi/vote/down?name=testname"));
}

void Ut_Remote::wakeTest()
{
    cond.wakeAll();
}


QTEST_MAIN(Ut_Remote)


