#include "ut_remotelist.h"

#include <QtTest>

void Ut_RemoteList::initTestCase()
{
    QStringList mfgs;
    mfgs << "Lg" << "Leadtek" << "Microsoft" << "Philips" << "Topfield";

    for (int i = 0; i < mfgs.size(); ++i)
    {
        QChar letter = mfgs.at(i).at(0);
        QStringList l;

        for (int j = 0; j < mfgs.size(); ++j)
        {
            if (mfgs.at(j).at(0) == letter)
                l << mfgs.at(j);
        }
        validMfgs.insert(letter, l);
        l.clear();
    }

    // TODO rewrite
    validModels.insert("Lg", QList<Model>());
    validModels["Lg"].append(Model("AKB69680403", "AKB69680_00"));

    validModels.insert("Leadtek", QList<Model>()); 
    validModels["Leadtek"].append(Model("Y04G0004", "Y04G0004_00"));

    validModels.insert("Microsoft", QList<Model>()); 
    validModels["Microsoft"].append(Model("Xbox360", "Xbox360_00"));

    validModels.insert("Philips", QList<Model>()); 
    validModels["Philips"].append(Model("15PF4121", "15PF4121_00"));
    validModels["Philips"].append(Model("modelname", "filename"));

    validModels.insert("Topfield", QList<Model>()); 
    validModels["Topfield"].append(Model("PVR5000", "PVR_5000_00"));

    createDocument();
}

void Ut_RemoteList::cleanupTestCase()
{
}

void Ut_RemoteList::createDocument()
{
    QDomElement root = document.createElement("db");
    document.appendChild(root);

    for (int i = 0; i < validMfgs.keys().size(); ++i)
    {
        QChar letter = validMfgs.keys().at(i).at(0);
        QDomElement charEl = document.createElement("char");
        charEl.setAttribute("id", letter);
        createMfgElements(letter, charEl);
        root.appendChild(charEl);
    }
}

void Ut_RemoteList::createMfgElements(QChar &letter, QDomElement &parent)
{
    for (int i = 0; i < validMfgs[letter].size(); ++i)
    {
        QString mfg = validMfgs[letter].at(i);
        QDomElement mfgEl = document.createElement("mfg");
        mfgEl.setAttribute("id", mfg);
        createModelElements(mfg, mfgEl);
        parent.appendChild(mfgEl);
    }
}

void Ut_RemoteList::createModelElements(const QString &mfg, QDomElement &parent)
{
    for (int i = 0; i < validModels[mfg].size(); ++i)
    {
        Model m = validModels[mfg].at(i);
        QDomElement modelEl = document.createElement("model");
        modelEl.setAttribute("file", m.file);
        modelEl.setAttribute("name", m.name);
        parent.appendChild(modelEl);
    }
}

void Ut_RemoteList::testIsValid()
{
    RemoteList subject(document);
    QCOMPARE(subject.isValid(), true);
}

void Ut_RemoteList::testIsValid_setContent()
{
    RemoteList subject;
    QCOMPARE(subject.isValid(), false);
    subject.setContent(document);
    QCOMPARE(subject.isValid(), true);
}

void Ut_RemoteList::testLetters()
{
    RemoteList subject(document);
    compareLetters(subject);
}

void Ut_RemoteList::testManufacturers()
{
    RemoteList subject(document);
    compareManufacturers(subject);
}

void Ut_RemoteList::testModels()
{
    RemoteList subject(document);
    compareModels(subject);
}

void Ut_RemoteList::testLetters_setContent()
{
    RemoteList subject;
    subject.setContent(document);
    compareLetters(subject);
}

void Ut_RemoteList::testManufacturers_setContent()
{
    RemoteList subject;
    subject.setContent(document);
    compareManufacturers(subject);
}

void Ut_RemoteList::testModels_setContent()
{
    RemoteList subject;
    subject.setContent(document);
    compareModels(subject);
}

void Ut_RemoteList::compareLetters(RemoteList &subject)
{
    QStringList letters = subject.letters();
    QStringList validLetters = validMfgs.keys();

    QCOMPARE(validLetters.size(), letters.size());

    for (int i = 0; i < letters.size(); ++i)
    {
        QCOMPARE(validLetters.at(i), letters.at(i));
    }
}

void Ut_RemoteList::compareManufacturers(RemoteList &subject)
{
    for (int i = 0; i < validMfgs.keys().size(); ++i)
    {
        QString letter = validMfgs.keys().at(i);
        for (int j = 0; j < validMfgs.value(letter).size(); ++j)
        {
            QCOMPARE(validMfgs.value(letter).at(j), 
                     subject.manufacturers(letter).at(j));
        }
    }
}

void Ut_RemoteList::compareModels(RemoteList &subject)
{
    for (int i = 0; i < validModels.keys().size(); ++i)
    {
        QString mfg = validModels.keys().at(i);
        for (int j = 0; j < validModels.value(mfg).size(); ++j)
        {
            QCOMPARE(validModels.value(mfg).at(j).name,
                     subject.models(mfg).at(j).name);
            QCOMPARE(validModels.value(mfg).at(j).file,
                    subject.models(mfg).at(j).file);
        }
    }
}


QTEST_MAIN(Ut_RemoteList)


