#include "selectremotedlg.h"

#include "remote.h"
#include "remotelistwidgetitem.h"

#include <QHBoxLayout>
#include <QLabel>
#include <QString>
#include <QListWidget>
#include <QListWidgetItem>
#include <QSettings>
#include <QMap>
#include <QList>
#include <QMessageBox>
#include <QPushButton>

SelectRemoteDlg::SelectRemoteDlg(QWidget *parent)
    : QDialog(parent)
{
    this->setWindowTitle(tr("Select remote"));
    this->setMinimumHeight(320);

    layout = new QHBoxLayout(this);

    alphabetList = new QListWidget(this);
    alphabetList->setMaximumWidth(96);
    layout->addWidget(alphabetList);
    connect(alphabetList,
            SIGNAL(currentItemChanged(QListWidgetItem*, QListWidgetItem*)),
            this,
            SLOT(alphabetItemChanged(QListWidgetItem*, QListWidgetItem*)));
    
    mfgList = new QListWidget(this);
    layout->addWidget(mfgList);
    connect(mfgList,
            SIGNAL(currentItemChanged(QListWidgetItem*, QListWidgetItem*)),
            this,
            SLOT(mfgItemChanged(QListWidgetItem*, QListWidgetItem*)));

    modelList = new QListWidget(this);
    layout->addWidget(modelList);

    downloadBtn = new QPushButton(tr("Download"), this);
    layout->addWidget(downloadBtn);
    connect(downloadBtn, SIGNAL(clicked()), 
            this, SLOT(downloadRemote()));

    this->setLayout(layout);
    setBusy(true);
    connect(&remoteDBMgr, SIGNAL(dbReady(RemoteDB*)),
            this, SLOT(setDB(RemoteDB*)));
    remoteDBMgr.getDBAsync();
}


SelectRemoteDlg::~SelectRemoteDlg()
{
    delete layout;
}

void SelectRemoteDlg::setDB(RemoteDB *db)
{
    remoteDB = db;
    alphabetList->addItems(remoteDB->keys());
    setBusy(false);
}

void SelectRemoteDlg::setBusy(bool busy)
{
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, busy);
    setEnabled(!busy);
}

void SelectRemoteDlg::alphabetItemChanged(QListWidgetItem *current,
                                      QListWidgetItem * /*previous*/)
{
    mfgList->clear();
    modelList->clear();
    if (current)
    {
        mfgList->addItems((*remoteDB)[current->text()].keys());
    }
}

void SelectRemoteDlg::mfgItemChanged(QListWidgetItem *current,
                                     QListWidgetItem * /*previous*/)
{
    modelList->clear();
    if (current)
    {
        RemoteList remotes =
            (*remoteDB)[alphabetList->currentItem()->text()][current->text()];
        foreach(Remote *remote, remotes) {
            modelList->addItem(new RemoteListWidgetItem(remote));
        }
    }
}

void SelectRemoteDlg::downloadRemote()
{
    RemoteListWidgetItem *currentModel =
        static_cast<RemoteListWidgetItem *>(modelList->currentItem());
    if (currentModel)
    {
        setBusy();
        connect(currentModel->remote(), SIGNAL(saveFinished()),
                this, SLOT(close()));
        currentModel->remote()->saveToFile();

        emit remoteChanged(*(currentModel->remote()));
    }
}

