#ifndef REMOTEDBMGR_H
#define REMOTEDBMGR_H

#include <QObject>
#include <QNetworkAccessManager>
#include "remotedb.h"

class QDomDocument;
class QDomElement;

class RemoteDBMgr : public QObject
{
    Q_OBJECT
public:
    RemoteDBMgr();
    ~RemoteDBMgr();

    void getDBAsync();

signals:
    void dbReady(RemoteDB *);

private slots:
    void dbDownloadFinished(QNetworkReply *reply);

private:
    void parse(QDomDocument &doc);
    MfgMap parseMfgMap(QDomElement &charEl);
    RemoteList parseRemotes(QDomElement &mfgEl);

    RemoteDB db;
    QNetworkAccessManager netAM;
};

#endif


