#include "mainwidget.h"
#include "settingsdlg.h"
#include "advsettingsdlg.h"

#include <QInputDialog>
#include <QPainter>
#include <QGridLayout>
#include <QToolButton>
#include <QSettings>

MainWidget::MainWidget (QWidget *parent)
    : QWidget(parent)
{
    // reset settings to defaults
    AdvSettingsDlg asd(this);

    layout = new QGridLayout(this);

    settings = new QSettings(this);

    char iconNames[][128] = {
        "/usr/share/icons/hicolor/48x48/hildon/statusarea_volumelevel4.png",
        "/usr/share/icons/hicolor/48x48/hildon/statusarea_volumelevel1.png",
        "/usr/share/icons/hicolor/48x48/hildon/rss_reader_move_up.png",
        "/usr/share/icons/hicolor/48x48/hildon/rss_reader_move_down.png",
        "/usr/share/icons/hicolor/48x48/hildon/location_applet_on.png",
        "/usr/share/icons/hicolor/48x48/hildon/statusarea_volume_mute.png"
    };

    for (int i = 0; i < BUTTON_COUNT; ++i) {
        QToolButton *button = new QToolButton(this);
        button->setIcon(QIcon(QString(
            settings->value(QString("buttonIcon") + QString::number(i),
                iconNames[i]).toString()))); 
        buttons[i] = button;
        button->setSizePolicy(QSizePolicy::MinimumExpanding,
                QSizePolicy::MinimumExpanding);
        layout->addWidget(button, i%2, i/2);
    }

    connect(buttons[0], SIGNAL(clicked()), this, SLOT(sendCmdVolUp()));
    connect(buttons[1], SIGNAL(clicked()), this, SLOT(sendCmdVolDown()));
    connect(buttons[2], SIGNAL(clicked()), this, SLOT(sendCmdChUp()));
    connect(buttons[3], SIGNAL(clicked()), this, SLOT(sendCmdChDown()));
    connect(buttons[4], SIGNAL(clicked()), this, SLOT(sendCmdPower()));
    connect(buttons[5], SIGNAL(clicked()), this, SLOT(sendCmdMute()));

    setContentsMargins(0, 0, 0, 0);
    layout->setContentsMargins(0, 0, 0, 0);
    setLayout(layout);
    setAttribute(Qt::WA_TranslucentBackground);
    setAttribute(Qt::WA_OpaquePaintEvent);
    resize();
}

MainWidget::~MainWidget()
{
    delete settings;
}

void MainWidget::sendCmdVolUp()
{
    irCtrl.sendCmd(settings->value("volUpCmd", "VOLUP").toString());
}

void MainWidget::sendCmdVolDown()
{
    irCtrl.sendCmd(settings->value("volDownCmd", "VOLDOWN").toString());
}

void MainWidget::sendCmdChUp()
{
    irCtrl.sendCmd(settings->value("chUpCmd", "CHUP").toString());
}

void MainWidget::sendCmdChDown()
{
    irCtrl.sendCmd(settings->value("chDownCmd", "CHDOWN").toString());
}

void MainWidget::sendCmdPower()
{
    irCtrl.sendCmd(settings->value("powerCmd", "POWER").toString());
}

void MainWidget::sendCmdMute()
{
    irCtrl.sendCmd(settings->value("muteCmd", "MUTE").toString());
}

void MainWidget::paintEvent(QPaintEvent *)
{
    int bgAlpha = settings->value("bgAlpha", "192").toInt();
    QPainter p(this);
    p.fillRect(rect(), QColor(0, 0, 0, bgAlpha));
    p.end();
}
 
void MainWidget::showSettingsDialog()
{
    SettingsDlg dlg;
    dlg.exec();
    update(); // Repaint required if bgAlpha value was changed
    resize();
}

void MainWidget::resize()
{
    int w = settings->value("width", "250").toInt();
    int h = settings->value("height", "148").toInt();
    if (w < 1)
        w = 250;
    if (h < 1)
        h = 148;
    QWidget::resize(w, h);
}


