#include "selectremotedlg.h"

#include <cstdlib>

#include <QDebug>
#include <QHBoxLayout>
#include <QLabel>
#include <QString>
#include <QListWidget>
#include <QListWidgetItem>
#include <QSettings>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkReply>
#include <QBuffer>
#include <QByteArray>
#include <QFile>
#include <QMap>
#include <QMessageBox>
#include <QPushButton>
#include <QListWidgetItem>

SelectRemoteDlg::SelectRemoteDlg(QWidget *parent)
    : QDialog(parent)
{
    this->setWindowTitle(tr("Select remote"));
    this->setMinimumHeight(320);

    deviceNameMap = new QMap<QString, QString>();

    //TODO caching?
    mfgNetAM = new QNetworkAccessManager(this);
    connect(mfgNetAM, SIGNAL(finished(QNetworkReply*)), 
            this,  SLOT(mfgListDownloadFinished(QNetworkReply*)));

    modelNetAM = new QNetworkAccessManager(this);
    connect(modelNetAM, SIGNAL(finished(QNetworkReply*)), 
            this,  SLOT(modelListDownloadFinished(QNetworkReply*)));

    remoteNetAM = new QNetworkAccessManager(this);
    connect(remoteNetAM, SIGNAL(finished(QNetworkReply*)), 
            this,  SLOT(remoteDownloadFinished(QNetworkReply*)));
    
    settings = new QSettings(this);

    layout = new QHBoxLayout(this);

    alphabetList = new QListWidget(this);
    alphabetList->setMaximumWidth(96);
    for (char c = 'a'; c <= 'z'; ++c)
    {
        alphabetList->addItem(QString(c));
    }
    layout->addWidget(alphabetList);
    connect(alphabetList, SIGNAL(currentItemChanged(QListWidgetItem*, QListWidgetItem*)),
                this, SLOT(alphabetItemChanged(QListWidgetItem*, QListWidgetItem*)));
    
    mfgList = new QListWidget(this);
    layout->addWidget(mfgList);
    connect(mfgList, SIGNAL(currentItemChanged(QListWidgetItem*, QListWidgetItem*)),
                this, SLOT(mfgItemChanged(QListWidgetItem*, QListWidgetItem*)));

    modelList = new QListWidget(this);
    layout->addWidget(modelList);

    downloadBtn = new QPushButton(tr("Download"), this);
    layout->addWidget(downloadBtn);
    connect(downloadBtn, SIGNAL(clicked()), 
            this, SLOT(downloadRemote()));

    this->setLayout(layout);
}

SelectRemoteDlg::~SelectRemoteDlg()
{
    delete layout;
    layout = NULL;
    delete settings;
    settings = NULL;
    delete mfgNetAM;
    mfgNetAM = NULL;
    delete modelNetAM;
    modelNetAM = NULL;
    delete remoteNetAM;
    remoteNetAM = NULL;
    delete deviceNameMap;
    deviceNameMap = NULL;
}

void SelectRemoteDlg::setBusy(bool busy)
{
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, busy);
    setEnabled(!busy);
}

void SelectRemoteDlg::beginDownload(const QString &url, QNetworkAccessManager *nam)
{
    nam->get(QNetworkRequest(QUrl(url)));
    setBusy(true);
}

void SelectRemoteDlg::alphabetItemChanged(QListWidgetItem *current,
                                      QListWidgetItem * /*previous*/)
{
    QString url = settings->value("remoteUrl",
            "http://mercury.wipsl.com/irwi/remotes/").toString() +
            current->text() + ".txt";
    beginDownload(url, mfgNetAM);
}

void SelectRemoteDlg::mfgListDownloadFinished(QNetworkReply *reply)
{
    mfgList->clear();
    modelList->clear();
    if (reply->error() == QNetworkReply::NoError) {
        QByteArray ba = reply->readAll();
        QBuffer buf(&ba, this);
        buf.open(QIODevice::ReadOnly);
        buf.seek(0);
        while (buf.canReadLine())
        {
            QString str(buf.readLine());
            str.chop(1);
            mfgList->addItem(str);
        }
    } else {
        //qDebug() << (int)reply->error();
    }
    reply->close();
    reply->deleteLater();
    setBusy(false);
}

void SelectRemoteDlg::mfgItemChanged(QListWidgetItem *current,
                                     QListWidgetItem * /*previous*/)
{
    if (mfgList->currentItem() != NULL) {
        QString url = settings->value(
                "remoteUrl", "http://mercury.wipsl.com/irwi/remotes/").toString() 
            + alphabetList->currentItem()->text()
            + "/" + current->text() + ".txt";
        beginDownload(url, modelNetAM);
    }
}

void SelectRemoteDlg::modelListDownloadFinished(QNetworkReply *reply)
{
    modelList->clear();
    if (reply->error() == QNetworkReply::NoError) {
        QByteArray ba = reply->readAll();
        QBuffer buf(&ba, this);
        buf.open(QIODevice::ReadOnly);
        buf.seek(0);
        deviceNameMap->clear();
        while (buf.canReadLine())
        {
            QString str(buf.readLine());
            str.chop(1);
            QStringList strlist = str.split(":");
            if (strlist.count() == 2) {
                modelList->addItem(strlist[1]);
                deviceNameMap->insert(strlist[1], strlist[0]);
            }
        }
    } else {
        //qDebug() << (int)reply->error();
    }
    reply->close();
    reply->deleteLater();
    setBusy(false);
}

void SelectRemoteDlg::downloadRemote()
{
    QListWidgetItem *currentAlpha = alphabetList->currentItem();
    QListWidgetItem *currentMfg   = mfgList->currentItem();
    QListWidgetItem *currentModel = modelList->currentItem();
    if (currentModel && currentMfg && currentAlpha)
    {
        if (!currentModel->text().isEmpty()) {
            QString url = settings->value(
                    "remoteUrl",
                    "http://mercury.wipsl.com/irwi/remotes/").toString() 
                    + currentAlpha->text()
                    + "/" + currentMfg->text()
                    + "/" + (*deviceNameMap)[currentModel->text()];
            beginDownload(url, remoteNetAM);
            settings->setValue("remoteName", currentModel->text());
        }
    }
}

void SelectRemoteDlg::remoteDownloadFinished(QNetworkReply *reply)
{
    if (reply->error() == QNetworkReply::NoError) {
        QFile file(settings->value("lircConf", "/etc/lircd.conf").toString());
        if(file.open(QIODevice::WriteOnly))
        {
            file.write(reply->readAll());
            file.close();
        }
    }
    reply->close();
    reply->deleteLater();

    std::system("sudo /etc/init.d/lirc reload");

    emit remoteDownloaded();
    setBusy(false);
    QMessageBox mbox(QMessageBox::Information, tr("Success"),
            tr("Remote downloaded"), QMessageBox::Ok, this);
    mbox.exec();
    this->close();
}

