#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include <QWidget>

#include "irctrl.h"

class QGridLayout;
class QToolButton;
class QSettings;

class MainWidget : public QWidget
{
    Q_OBJECT
public:
    MainWidget (QWidget *parent = NULL);
    ~MainWidget();

public slots:
    void showSettingsDialog();

protected:
    void paintEvent(QPaintEvent *event);

private:
    void resize();
    static const int BUTTON_COUNT = 6;
    QGridLayout *layout;
    QToolButton *buttons[BUTTON_COUNT];
    IrCtrl irCtrl;
    QSettings *settings;
};

#endif

