#ifndef _IRCTRLPRIVATE_H_
#define _IRCTRLPRIVATE_H_

#include <QString>
#include <QObject>
#include "irctrl.h"

class QSettings;
class QTimer;

class IrCtrlPrivate : public QObject
{
    Q_OBJECT
public:
    IrCtrlPrivate();
    virtual ~IrCtrlPrivate();

protected:
    void genericSendCmd(const QString &commandName);
    void startLirc();

protected:
    IrCtrl *q_ptr;
    QSettings *settings;
    static const quint16 LIRC_PORT = 8765;
    QTimer *killLircTimer;

protected slots:
    void stopLirc();

private:
    IrCtrlPrivate(const IrCtrlPrivate &);
    Q_DECLARE_PUBLIC(IrCtrl);
};

#endif // _IRCTRLPRIVATE_H_

