#include <cstdlib>

#include <QTcpSocket>
#include <QHostAddress>
#include <QAbstractSocket>
#include <QSettings>
#include <QTimer>

#include "irctrl_p.h"

IrCtrlPrivate::IrCtrlPrivate()
    : settings(NULL)
{
    settings = new QSettings(this);

    killLircTimer = new QTimer(this);
    killLircTimer->setInterval(
            settings->value("idleTimeout", 300).toInt() * 1000);
    killLircTimer->setSingleShot(true);
    connect(killLircTimer, SIGNAL(timeout()), this, SLOT(stopLirc()));
    startLirc();
    killLircTimer->start();
}

IrCtrlPrivate::~IrCtrlPrivate()
{
    delete settings;
    settings = NULL;
    delete killLircTimer;
    stopLirc();
}

void IrCtrlPrivate::stopLirc()
{
    std::system("sudo /etc/init.d/lirc stop");
}

void IrCtrlPrivate::startLirc()
{
    std::system("sudo /etc/init.d/lirc start");
}

void IrCtrlPrivate::genericSendCmd(const QString &commandName)
{
    if (!killLircTimer->isActive()) {
        startLirc();
    } else {
        killLircTimer->stop();
    }

    QTcpSocket sock;
    sock.setSocketOption(QAbstractSocket::LowDelayOption, 1);
    sock.connectToHost(QHostAddress::LocalHost, 
            settings->value("lircPort", LIRC_PORT).toInt(),
            QIODevice::WriteOnly|QIODevice::Unbuffered);
    sock.waitForConnected();
    QString remoteName =
        settings->value("remoteName", "REMOTE_NAME_MISSING").toString();
    QString cmd = "SEND_ONCE " + remoteName + " " + commandName + "\n";
    sock.write(cmd.toAscii());
    sock.waitForBytesWritten();
    sock.close();

    killLircTimer->start();
}


