/*
 * irreco - Ir Remote Control
 * Copyright (C) 2008 Harri Vattulainen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

/**
 * @addtogroup IrrecoSelectRemoteDlg
 * @{
 */

/**
 * @file
 * Header file of @ref IrrecoSelectRemoteDlg.
 */

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Typedef                                                                    */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*
 * Make sure that typedefs are available before we include anything elese.
 *
 * This makes sure that whatever other structures that depend on structures
 * defined in this file will compile OK recardles of header inclusion order.
 */
#ifndef __IRRECO_SELECT_REMOTE_DLG_H_TYPEDEF__
#define __IRRECO_SELECT_REMOTE_DLG_H_TYPEDEF__

#define IRRECO_TYPE_SELECT_REMOTE_DLG irreco_select_remote_dlg_get_type()
#define IRRECO_SELECT_REMOTE_DLG(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), IRRECO_TYPE_SELECT_REMOTE_DLG, IrrecoSelectRemoteDlg))
#define IRRECO_SELECT_REMOTE_DLG_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), IRRECO_TYPE_SELECT_REMOTE_DLG, IrrecoSelectRemoteDlgClass))
#define IRRECO_IS_SELECT_REMOTE_DLG(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IRRECO_TYPE_SELECT_REMOTE_DLG))
#define IRRECO_IS_SELECT_REMOTE_DLG_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), IRRECO_TYPE_SELECT_REMOTE_DLG))
#define IRRECO_SELECT_REMOTE_DLG_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), IRRECO_TYPE_SELECT_REMOTE_DLG, IrrecoSelectRemoteDlgClass))

typedef struct _IrrecoSelectRemoteDlg IrrecoSelectRemoteDlg;
typedef struct _IrrecoSelectRemoteDlgClass IrrecoSelectRemoteDlgClass;

#endif /* __IRRECO_SELECT_REMOTE_DLG_H_TYPEDEF__ */



/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Include                                                                    */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
#ifndef __IRRECO_SELECT_REMOTE_DLG_H__
#define __IRRECO_SELECT_REMOTE_DLG_H__
#include "irreco.h"
#include "irreco_dlg.h"
#include "irreco_data.h"



/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Datatypes                                                                  */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

struct _IrrecoSelectRemoteDlg {
	IrrecoDlg 		 parent;
	IrrecoData 		*irreco_data;

	GtkListStore		*store;
	GtkTreeView		*tree;
	GtkCellRenderer		*renderer;
	GtkTreeViewColumn	*column;
	GtkTreeSelection	*select;

	GtkWidget		*hbox;
	GtkWidget		*change_button;
};

struct _IrrecoSelectRemoteDlgClass {
	IrrecoDlgClass parent_class;
};



/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Macro                                                                      */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/



/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Prototypes                                                                 */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
GType irreco_select_remote_dlg_get_type(void);
void irreco_show_select_remote_dlg(IrrecoWindowUser *user_window);


#endif /* __IRRECO_SELECT_REMOTE_DLG_H__ */

/** @} */
