/*
 * irreco - Ir Remote Control
 * Copyright (C) 2008 Harri Vattulainen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "irreco_select_remote_dlg.h"
#include "irreco_config.h"
#include <hildon/hildon-gtk.h>
#include <hildon/hildon-pannable-area.h>


/**
 * @addtogroup IrrecoSelectRemoteDlg
 * @ingroup Irreco
 *
 * @todo PURPOCE OF CLASS.
 *
 * @{
 */

/**
 * @file
 * Source file of @ref IrrecoSelectRemoteDlg.
 */


/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Prototypes                                                                 */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
static gboolean irreco_show_select_remote_dlg_map_event(IrrecoSelectRemoteDlg *self,
							GdkEvent  *event,
							gpointer   user_data);
static void irreco_show_select_remote_dlg_destroy_event(IrrecoSelectRemoteDlg *self,
							gpointer user_data);
void irreco_select_remote_dlg_set_irreco_data(IrrecoSelectRemoteDlg *self,
					      IrrecoData *irreco_data);
GtkWidget *irreco_select_remote_dlg_new(IrrecoData *irreco_data,
					GtkWindow *parent);
void irreco_select_remote_dlg_button_click(GtkButton *button,
					   IrrecoSelectRemoteDlg *self);
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Datatypes                                                                  */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Construction & Destruction                                                 */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

/**
 * @name Construction & Destruction
 * @{
 */

G_DEFINE_TYPE(IrrecoSelectRemoteDlg, irreco_select_remote_dlg, IRRECO_TYPE_DLG)

static void irreco_select_remote_dlg_finalize(GObject *object)
{
	if (G_OBJECT_CLASS(irreco_select_remote_dlg_parent_class)->finalize)
		G_OBJECT_CLASS(irreco_select_remote_dlg_parent_class)->finalize(object);
}

static void irreco_select_remote_dlg_class_init(IrrecoSelectRemoteDlgClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS(klass);
	object_class->finalize = irreco_select_remote_dlg_finalize;
}


static void irreco_select_remote_dlg_init(IrrecoSelectRemoteDlg *self)
{
	GtkTreeSelection *select;
	GtkWidget *tree_view_frame;
	GtkWidget *tree_view_pannable;

	IRRECO_ENTER

	self->change_button = gtk_button_new_with_label("Change");

	/* Construct dialog. */
	gtk_window_set_title(GTK_WINDOW(self),
			     _("Change remote"));
	gtk_window_set_modal(GTK_WINDOW(self), TRUE);
	gtk_window_set_destroy_with_parent(GTK_WINDOW(self), TRUE);
	gtk_dialog_set_has_separator(GTK_DIALOG(self), FALSE);

	self->change_button = gtk_dialog_add_button(GTK_DIALOG(self),
				_("Change"), GTK_RESPONSE_OK);
	/* Create hbox */
	self->hbox = g_object_new(GTK_TYPE_HBOX, NULL);
	gtk_box_set_spacing(GTK_BOX(self->hbox), 8);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(self)->vbox),
			  irreco_gtk_align(GTK_WIDGET(self->hbox),
					   0, 0, 1, 1, 8, 8, 8, 8));


	/* List */
	self->store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_POINTER);
	self->tree = GTK_TREE_VIEW(hildon_gtk_tree_view_new_with_model(1,
					GTK_TREE_MODEL(self->store)));
	self->renderer = gtk_cell_renderer_text_new();
	self->column = gtk_tree_view_column_new_with_attributes(NULL,
							self->renderer,
							"text",
							0,
							NULL);
	gtk_tree_view_append_column(self->tree, self->column);
	self->select = gtk_tree_view_get_selection (GTK_TREE_VIEW (self->tree));
	gtk_tree_selection_set_mode(self->select, GTK_SELECTION_SINGLE);


	/* Create tree_view_hbox */
	tree_view_pannable = hildon_pannable_area_new();
	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(tree_view_pannable),
					       GTK_WIDGET(self->tree));

	/* Create Frame for Treeview */
	tree_view_frame = gtk_frame_new("");
	gtk_frame_set_label_widget(GTK_FRAME(tree_view_frame),
		irreco_gtk_label_bold("Remotes", 0, 0, 0, 0, 0, 0));

	gtk_container_add(GTK_CONTAINER(tree_view_frame),
			  GTK_WIDGET(tree_view_pannable));

	gtk_box_pack_start(GTK_BOX(self->hbox), GTK_WIDGET(tree_view_frame),
			   TRUE, TRUE, 0);

	/* Setup the selection handler for TREE	*/
	select = gtk_tree_view_get_selection(self->tree);
	gtk_tree_selection_set_mode(select, GTK_SELECTION_SINGLE);

	/* Signal handlers. */
	g_signal_connect(G_OBJECT (self->change_button), "clicked",
			 G_CALLBACK (irreco_select_remote_dlg_button_click), self);
	g_signal_connect(G_OBJECT(self), "map-event",
			 G_CALLBACK(irreco_show_select_remote_dlg_map_event), NULL);
	g_signal_connect(G_OBJECT(self), "destroy",
			 G_CALLBACK(irreco_show_select_remote_dlg_destroy_event), NULL);

	gtk_widget_set_size_request(GTK_WIDGET(self), -1, 335);
	gtk_widget_show_all(GTK_WIDGET(self));

	IRRECO_RETURN
}

GtkWidget *irreco_select_remote_dlg_new(IrrecoData *irreco_data,
					GtkWindow *parent)
{
	IrrecoSelectRemoteDlg *self;
	IRRECO_ENTER

	self = g_object_new(IRRECO_TYPE_SELECT_REMOTE_DLG, NULL);
	irreco_dlg_set_parent(IRRECO_DLG(self), parent);
	irreco_select_remote_dlg_set_irreco_data(self, irreco_data);
	IRRECO_RETURN_PTR(self);
}

/** @} */

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Private Functions                                                          */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

/**
 * @name Private Functions
 * @{
 */

gboolean irreco_select_remote_dlg_change(IrrecoSelectRemoteDlg *self)
{
	gboolean rvalue = FALSE;

	IRRECO_ENTER

	IRRECO_RETURN_BOOL(rvalue);
}

/** @} */

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Functions                                                                  */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

/**
 * @name Public Functions
 * @{
 */

void irreco_select_remote_dlg_set_irreco_data(IrrecoSelectRemoteDlg *self,
				      IrrecoData *irreco_data)
{
	IRRECO_ENTER
	self->irreco_data = irreco_data;
	IRRECO_RETURN
}

void irreco_show_select_remote_dlg(IrrecoWindowUser *user_window)
{
	IrrecoSelectRemoteDlg	*self;
	gint			response;
	gboolean		loop = TRUE;

	IRRECO_ENTER

	self = IRRECO_SELECT_REMOTE_DLG(
			irreco_select_remote_dlg_new(
				user_window->irreco_data,
				irreco_window_get_gtk_window(user_window->window)));

	do {
		response = gtk_dialog_run(GTK_DIALOG(self));
		switch (response) {

		case GTK_RESPONSE_DELETE_EVENT:
			IRRECO_DEBUG("GTK_RESPONSE_DELETE_EVENT\n");
			loop = FALSE;
			break;
		}
	} while (loop);

	gtk_widget_destroy(GTK_WIDGET(self));
	IRRECO_RETURN
}

/** @} */


/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Events and Callbacks                                                       */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

/**
 * @name Events and Callbacks
 * @{
 */

void irreco_select_remote_dlg_button_click(GtkButton *button,
					   IrrecoSelectRemoteDlg *self)
{
	GtkTreeIter		iter;
	GtkTreeModel		*model;
	IrrecoButtonLayout	*layout;

	IRRECO_ENTER

        if (gtk_tree_selection_get_selected (self->select, &model, &iter))
        {
                gtk_tree_model_get (model, &iter, 1, &layout, -1);

		g_print ("layout: %s\n", layout->name->str);
		irreco_window_manager_set_layout(self->irreco_data->window_manager, layout);
		gtk_dialog_response(GTK_DIALOG(self),
				    GTK_RESPONSE_DELETE_EVENT);
        }

	IRRECO_RETURN
}

static gboolean irreco_show_select_remote_dlg_map_event(IrrecoSelectRemoteDlg *self,
						GdkEvent *event,
						gpointer user_data)
{
	GtkTreeIter	iter;

	IRRECO_ENTER

	IRRECO_STRING_TABLE_FOREACH(self->irreco_data->irreco_layout_array,
				    key,
				    IrrecoButtonLayout *,
				    layout)

		gtk_list_store_append (self->store, &iter);
		gtk_list_store_set(self->store, &iter, 0, key, 1, layout, -1);

	IRRECO_STRING_TABLE_FOREACH_END

	IRRECO_RETURN_BOOL(TRUE);
}

static void irreco_show_select_remote_dlg_destroy_event(IrrecoSelectRemoteDlg *self,
							gpointer user_data)
{
	IRRECO_ENTER
	IRRECO_RETURN
}

/** @} */
/** @} */

