/**
 * intervalometer
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to tomi.suviola@gmail.com so I can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 Tomi Suviola
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

#ifndef ECHODIALOG_H
#define ECHODIALOG_H

#include <QWidget>

#include "ui_intervalwindow.h"
#include "interval.h"
#include "camerainterface.h"

const QString APPNAME = QString("Interval-o-meter");

QT_BEGIN_NAMESPACE
class QString;
class QLineEdit;
class QLabel;
class QPushButton;
class QGridLayout;
QT_END_NAMESPACE


class IntervalWindow : public QWidget
{
    Q_OBJECT

public:
    IntervalWindow(Interval *model);

public slots:
    void done();
    void start();

private slots:
    void on_pushButtonOnOff_clicked();
    void on_pushButtonReset_clicked();
    void on_pushButtonTrigger_clicked();

    void on_actionAdvanced_triggered();
    void on_actionSimple_triggered();
    void on_actionPlugins_triggered();

    void on_spinBox_SelfH_valueChanged(int val);
    void on_spinBox_SelfM_valueChanged(int val);
    void on_spinBox_SelfS_valueChanged(int val);

    void on_spinBox_LongH_valueChanged(int val);
    void on_spinBox_LongM_valueChanged(int val);
    void on_spinBox_LongS_valueChanged(int val);

    void on_spinBox_IntH_valueChanged(int val);
    void on_spinBox_IntM_valueChanged(int val);
    void on_spinBox_IntS_valueChanged(int val);

    void on_spinBox_Frames_valueChanged(int val);
private:
    Interval *m_model;
    Ui::MainForm ui;
    bool m_on;
};


#endif
