/**
 * intervalometer
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to tomi.suviola@gmail.com so I can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 Tomi Suviola
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

#include <QtGui>
#include <QtGlobal>
#include "n900cam.h"


QString N900CamPlugin::name()
{
    qDebug("n900cam");
    return "n900cam";
}

void N900CamPlugin::open()
{
    qDebug("open");
    QSettings settings;
    int width=0;
    int height=0;

    QString cam;
    if ( !settings.value("n900/camera",QString("front")).toString().compare(QString("back"),Qt::CaseInsensitive) )
        cam="1";
    else
        cam="0";

    width = settings.value("n900/width",800).toInt();
    height = settings.value("n900/height",600).toInt();
    QString path = settings.value("n900/path","/home/user/MyDocs/interval/").toString();

    if (cam =="1") {
        width=qMax(0,qMin(640,width));
        height=qMax(0,qMin(480,height));
    } else { //2584 x 1938
        width=qMax(0,qMin(2576,width));
        height=qMax(0,qMin(1938,height));
    }
    //write settings back corrected
    if (cam=="1")
        settings.setValue("n900/camera","back");
    else
        settings.setValue("n900/camera","front");

    settings.setValue("n900/width",width);
    settings.setValue("n900/height",height);
    settings.setValue("n900/path",path);

    m_command = QString("/usr/bin/gst-launch-0.10 v4l2camsrc device=/dev/video%1 "
                        "num-buffers=1 ! ffmpegcolorspace ! "
                        "video/x-raw-yuv,width=%2,height=%3 ! "
                        "jpegenc ! filesink location=%4/")
                .arg(cam).arg(width).arg(height).arg(path);

}

void N900CamPlugin::close()
{
    qDebug("close");
}

void N900CamPlugin::shutter(const bool open)
{
    qDebug("shutter");
    if (open) {
        qDebug("on");
        QDateTime date = QDateTime::currentDateTime();
        QString filename = date.toString("yyyy-MM-dd_hh-mm-ss.jpg");
        int res = QProcess::execute(m_command+filename);
        qDebug() << m_command+filename;
    } else
        qDebug("off");
}

void N900CamPlugin::focus(const bool open)
{
    qDebug("focus");
    if (open)
        qDebug("on");
    else
        qDebug("off");
}

Q_EXPORT_PLUGIN2(n900plugin, N900CamPlugin);
