#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QCheckBox>
#include <QComboBox>
#include <QSlider>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QSettings>
#include <QVBoxLayout>
#include <QHBoxLayout>

class SettingsDialog : public QDialog
{
    Q_OBJECT
public:
    explicit SettingsDialog(QWidget *parent = 0);

private:
    QPushButton *saveButton;
    QCheckBox *showNotificationsCheckBox;
    QCheckBox *saveLogCheckBox;
    QSlider *alphaValueSlider;
    QLabel *alphaValueLabel;
    QLabel *urlLabel;
    QLabel *iconLabel;
    QComboBox *iconComboBox;
    QLineEdit *urlLineEdit;

    bool showNotifications;
    bool saveLog;
    int alphaValue;
    QString url;
    QString icon;

signals:
    void saveButtonClicked();

public slots:
    void on_saveButton_clicked();

};

#endif // SETTINGSDIALOG_H
