#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "settingsdialog.h"

#include <QMainWindow>

#include <QDateTime>
#include <QFile>
#include <QLabel>
#include <QMaemo5InformationBox>
#include <QPainter>
#include <QPushButton>
#include <QSettings>
#include <QString>
#include <QTextStream>
#include <QtMultimediaKit/QMediaService>
#include <QtMultimediaKit/QMediaPlayer>



class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    QMediaPlayer *player;
    QString url;
    QString icon;
    bool running;
    bool showNotifications;
    bool saveLog;
    QMaemo5InformationBox *infoBox;
    QPushButton *button;
    QLabel *label;
    int alphaValue;
    SettingsDialog *settingsDialog;


signals:

public slots:
    void buttonClicked();
    void showSettingsDialog();
    void getMetaData();
    void readSettings();

protected:
    void paintEvent(QPaintEvent *event)
    {
        QPainter p(this);
        p.setBrush(QColor(0, 0, 0, alphaValue));
        p.setPen(Qt::NoPen);
        p.drawRoundedRect(rect(), 8, 8);
        p.end();

        QWidget::paintEvent(event);
    }

};

#endif // MAINWINDOW_H
