#include <QtGui/QApplication>
#include "mainwindow.h"
#include "qmaemo5homescreenadaptor.h"

int main(int argc, char *argv[])
{
    QApplication::setGraphicsSystem("native");

    QApplication a(argc, argv);

    MainWindow w;

    QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&w);
    adaptor->setSettingsAvailable(true);

    QObject::connect(adaptor, SIGNAL(settingsRequested()), &w, SLOT(showSettingsDialog()));

#if defined(Q_WS_S60)
    w.showMaximized();
#else
    w.show();
#endif

    return a.exec();
}
