#include "stationsdb.h"

StationsDB::StationsDB()
{

}

QStringList StationsDB::getFullStationList(OrderBy orderBy)
{

    QSqlQuery query( db );
    switch ( orderBy )
    {
        case OrderByName: query.exec("SELECT name, url, country, genre FROM stations ORDER BY name"); break;
        case OrderByGenre: query.exec("SELECT name, url, country, genre FROM stations ORDER BY genre ASC, name ASC"); break;
        case OrderByCountry: query.exec("SELECT name, url, country, genre FROM stations ORDER BY country ASC, name ASC"); break;
    }



    QStringList stationsList;
    while (query.next())
    {
             QString name = query.value(0).toString();
             QString url = query.value(1).toString();
             QString country = query.value(2).toString();
             QString genre = query.value(3).toString();

             stationsList<<QString("%1 [%2] [%3]--%4").arg(name).arg(country).arg(genre).arg(url);
    }


    return stationsList;

}

void StationsDB::checkDB()
{
    QFile db(QString("%1/.config/internetradioplayer/stations.db").arg(QDir::homePath()));
    if (db.exists())
    {
        qDebug()<<"Database file exists";
        return;
    }
    else
    {
        QDir configDir( QString("%1/.config/internetradioplayer").arg(QDir::homePath()) );

        if ( !configDir.exists() )
        {
            configDir.mkdir( QString("%1/.config/internetradioplayer").arg(QDir::homePath()) );
        }

        qDebug()<<"Database file does not exist";
        system("echo 'cp /opt/internetradioplayer/db/stations.db /home/user/.config/internetradioplayer' | root ");
        system("echo 'chown user /home/user/.config/internetradioplayer/stations.db' | root ");
        system("echo 'chmod +rw /home/user/.config/internetradioplayer/stations.db' | root ");
    }
}

void StationsDB::clearDB()
{

    QSqlQuery query( db );
    qDebug()<<query.exec("DELETE FROM stations");
    qDebug()<<query.lastError();

}

void StationsDB::initDB()
{
    db = QSqlDatabase::addDatabase("QSQLITE");
    QString path = QString("%1/.config/internetradioplayer/stations.db").arg(QDir::homePath());
    qDebug()<<path;
    db.setDatabaseName(path);
    db.open();
}

void StationsDB::restoreDefaultDB()
{
    system("echo 'cp /opt/internetradioplayer/db/stations.db /home/user/.config/internetradioplayer' | root ");
    system("echo 'chown user /home/user/.config/internetradioplayer/stations.db' | root ");
    system("echo 'chmod +rw /home/user/.config/internetradioplayer/stations.db' | root ");
}

QStringList StationsDB::getGenreList()
{
    QSqlQuery query( db );
    query.exec("SELECT DISTINCT genre FROM stations ORDER BY genre");

    QStringList genreList;
    while (query.next())
    {
             genreList<<query.value(0).toString();
    }

    return genreList;
}

QStringList StationsDB::getCountryList()
{
    QSqlQuery query( db );
    query.exec("SELECT DISTINCT country FROM stations ORDER BY country");

    QStringList countryList;
    while (query.next())
    {
             countryList<<query.value(0).toString();
    }

    return countryList;
}

QStringList StationsDB::getListFilteredByGenre(QString filter, OrderBy orderBy)
{
    QSqlQuery query( db );
    switch ( orderBy )
    {
        case OrderByName: query.exec(QString("SELECT name, url, country, genre FROM stations WHERE genre='%1' ORDER BY name").arg(filter)); break;
        case OrderByGenre: query.exec(QString("SELECT name, url, country, genre FROM stations WHERE genre='%1' ORDER BY genre").arg(filter)); break;
        case OrderByCountry: query.exec(QString("SELECT name, url, country, genre FROM stations WHERE genre='%1' ORDER BY country").arg(filter)); break;
    }


    QStringList stationsList;
    while (query.next())
    {
             QString name = query.value(0).toString();
             QString url = query.value(1).toString();
             QString country = query.value(2).toString();
             QString genre = query.value(3).toString();

             stationsList<<QString("%1 [%2] [%3]--%4").arg(name).arg(country).arg(genre).arg(url);
    }


    return stationsList;
}

QStringList StationsDB::getListFilteredByCountry(QString filter, OrderBy orderBy)
{
    QSqlQuery query( db );
    switch ( orderBy )
    {
        case OrderByName: query.exec(QString("SELECT name, url, country, genre FROM stations WHERE country='%1' ORDER BY name").arg(filter)); break;
        case OrderByGenre: query.exec(QString("SELECT name, url, country, genre FROM stations WHERE country='%1' ORDER BY genre").arg(filter)); break;
        case OrderByCountry: query.exec(QString("SELECT name, url, country, genre FROM stations WHERE country='%1' ORDER BY country").arg(filter)); break;
    }


    QStringList stationsList;
    while (query.next())
    {
             QString name = query.value(0).toString();
             QString url = query.value(1).toString();
             QString country = query.value(2).toString();
             QString genre = query.value(3).toString();

             stationsList<<QString("%1 [%2] [%3]--%4").arg(name).arg(country).arg(genre).arg(url);
    }


    return stationsList;
}

void StationsDB::insertStation(QString name, QString url, QString genre, QString country)
{
    QSqlQuery query( db );
    query.exec(QString("INSERT INTO stations (name, url, genre, country) VALUES ('%1', '%2', '%3', '%4')")
               .arg(name).arg(url).arg(genre).arg(country));
    qDebug()<<query.lastError()<<query.lastInsertId();
}

void StationsDB::deleteStation(QString url)
{
    QSqlQuery query( db );
    qDebug()<<query.exec( QString("DELETE FROM stations WHERE url='%1'").arg(url) );
    qDebug()<<query.lastError();
}

void StationsDB::updateStation(QString currentUrl, QString name, QString url, QString genre, QString country)
{
    QSqlQuery query( db );
    qDebug()<<query.exec( QString("UPDATE stations SET name='%1', url='%2', genre='%3', country='%4' WHERE url='%5'")
                          .arg(name).arg(url).arg(genre).arg(country).arg(currentUrl));
    qDebug()<<query.lastError();
}

void StationsDB::setFavourite(QString url, bool choice)
{
    if ( choice )
    {
        QSqlQuery query( db );
        qDebug()<<query.exec( QString("UPDATE stations SET favourite=1 WHERE url='%1'").arg(url) );
        qDebug()<<query.lastError();
    }
    else
    {
        QSqlQuery query( db );
        qDebug()<<query.exec( QString("UPDATE stations SET favourite=0 WHERE url='%1'").arg(url) );
        qDebug()<<query.lastError();
    }
}

QStringList StationsDB::getFavouriteList()
{
    QSqlQuery query( db );

    query.exec(QString("SELECT name, url, country, genre FROM stations WHERE favourite=1 ORDER BY name"));



    QStringList stationsList;
    while (query.next())
    {
             QString name = query.value(0).toString();
             QString url = query.value(1).toString();
             QString country = query.value(2).toString();
             QString genre = query.value(3).toString();

             stationsList<<QString("%1 [%2] [%3]--%4").arg(name).arg(country).arg(genre).arg(url);
    }


    return stationsList;
}

void StationsDB::addDefaultStations()
{
    QSqlQuery query( db );

    query.exec(QString("INSERT INTO \"stations\" VALUES('Belgium','Dance','Topradio FM','http://ns24907.ovh.net:8000',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Bulgaria','Folk','Radio ULTRA Pernik','http://88.80.96.25:8020/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Finland','Electronic','Radio KLF','http://217.30.180.245:80',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('France','Dance','Hotmix Radio Dance','mms://stream.hotmixmedias.net/hotmixradio',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Germany','Techno','TechnoBase.FM','http://listen.technobase.fm/tunein-dsl-asx',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Chill','InMyRadio Sensorama','http://76.73.125.26:8065',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Classical','Radio Onda 2','http://109.123.116.202:8010',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Classic','Radio Classica Bresciana','mmsh://radio.gruppoeditorialebresciana.it/radioclassica?MSWMExt=.asf',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Dance','Ibiza on Radio','http://81.174.67.45:8600',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Dance','Lolliradio Dance','http://94.23.206.43:8030',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Dance','Radio Byte Network','http://radiobyte128.servemp3.com:8018',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Dance','Radio Ciccio Riccio','http://78.159.121.98:8096',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Dance','Radio Dancefloor','http://190.120.229.146:8000',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Dance','Radio Deejay','mms://wm.streaming.kataweb.it/reflector:51783',0)"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Dance','Radio Ibiza','http://str2.creacast.com:80/radio_ibiza',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Dance','Radio Mela Vintage Dance','http://onlineshoutcast.com:8016/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Dance','Radio Planet FM','http://91.121.104.139:8100',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Dance','Radio Viva FM','mms://195.130.220.121/viva',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Folk','Radio Liscio e Folk','http://89.238.146.161:7012/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','House','M2O','mms://wm.streaming.kataweb.it/reflector:33153',0)"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','House','Radio 105 House','http://shoutcast.unitedradio.it:1203',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Jazz','Radio Cafè','http://onair15.xdevel.com:8008/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','News','Rai Radio 1 ','mmsh://a1435.l6935633352.c69356.e.lm.akamaistream.net/D/1435/69356/v0001/reflector:33352?MSWMExt=.asf',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','News','Rai Radio 2','mmsh://a532.l6935730531.c69357.e.lm.akamaistream.net/D/532/69357/v0001/reflector:30531?MSWMExt=.asf',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','News','Rai Radio 3','mmsh://a1044.l6935833043.c69358.e.lm.akamaistream.net/D/1044/69358/v0001/reflector:33043?MSWMExt=.asf',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Oldies','Golden Radio Italia 80s','http://83.170.89.19:8526/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Oldies','Italian Graffiati','http://s9.viastreaming.net:8000',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Oldies','R101 Ottanta','http://str30.creacast.com/r101_thema1',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Oldies','Radio 80','http://str01.fluidstream.net:7020/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Oldies','Radio Metro','http://wma02.fluidstream.net:8270/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Contoradio','http://streaming.controradio.emmi.it:8190',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Deegay Club','http://ss1.deegay.it:80/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Easy Network','http://str01.fluidstream.net:6040/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Golden Hit Radio','http://87.117.203.226:8014',0)"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','R101','http://str30.creacast.com/r101_thema4',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio 105 FM','http://shoutcast.unitedradio.it:1101/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Amore Catania','mms://onair6.xdevel.com/RadioAmoreCT',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Arancia','http://onair7.xdevel.com:8712',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Azzurra','mms://onair8.xdevel.com/RadioAzzurra',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio C1','http://audiomax.servemp3.com:8416/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Carini','http://onair11.xdevel.com:8120/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Company','http://str01.fluidstream.net:7010',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Erre 2','http://s6.mediastreaming.it:9044/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Graffiti','mms://onair1.xdevel.com/RadioGraffiti',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Italia','mms://89.202.214.2/66360a73-2b6d-483e-ae7e-29eee545d37c',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Italy','mmsh://tier1.radiostreamlive.com/radioitaly_128?MSWMExt=.asf',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Kiss Kiss History Hits','http://str31.creacast.com:80/kisskiss_history_hits',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Kiss Kiss Italia','http://str2.creacast.com:80/kisskiss_italia',0"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Kiss Kiss Napoli','http://str2.creacast.com:80/kisskiss_napoli',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio LatteMiele','http://onair7.xdevel.com:8084/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Margherita Network','http://shoutcast.streamingmedia.it:7072',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Naples','http://89.238.146.161:7018',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Napoli DOC','http://str30.creacast.com:80/radio_napolidoc',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Norba','mmsh://94.23.65.110/RadioNorba?MSWMExt=.asf',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Nostalgia Italia','mms://www.nostalgia.it/nostalgia',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Pico','http://onair11.xdevel.com:8064/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Radicale','http://livemp3.radioradicale.it/live.mp3',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Selene','http://94.23.29.154:8032',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Subasio Più','mms://onair14.xdevel.com/RadioSubasioPiu',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Suby','mms://onair1.xdevel.com/RadioSuby_1',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Radio Veneti nel Mondo','http://s2.fairprice-streams.de:9530',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','RDS','mms://fastreal.fastweb.it/RDS',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','RMC Monte Carlo Night','http://shoutcast.unitedradio.it:1115',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','RTL 102.5 FM','http://shoutcast.rtl.it:3010/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','TRS Radio','http://s1.viastreaming.net:8550/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Pop','Virgin Radio Italia','http://shoutcast.unitedradio.it:1301',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Rock','Virgin Rock 70','http://shoutcast.unitedradio.it:1119/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Romance','RMC Love Songs','http://shoutcast.unitedradio.it:1121/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Italy','Sport','Radio Centro Suono Sport','http://www.radiocentrosuono.it:8000/rcss',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Poland','Disco','PolskaStacja Italo Disco','http://188.165.23.150:9700',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Russia','Disco','101.ru Disco 80x','mmsh://fr1.101.ru/c7_0_128?MSWMExt=.asf',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Serbia','Pop','Radio Morava','http://87.117.204.38:8100/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Spain','Dance','Mortal FM','http://server2.20comunicacion.com:8044',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Spain','Electronic','Ibiza Sonica Radio','http://stream1.wft.es:1025',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Switzerland','House','Electro Radio','http://stream.electroradio.ch:26630',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Switzerland','Techno','UZIC Techno Minimal','http://stream.uzic.ch:9010/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('Switzerland','Trance','Trance Radio','http://server8.digital-webstream.de:10780',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','Adult Alternative','BBC 6 Music','http://www.bbc.co.uk/radio/listen/live/r6_aaclca.pls',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','Adult Contemporary','BBC Radio 2','http://www.bbc.co.uk/radio/listen/live/r2_aaclca.pls',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','Classical','BBC Radio 3','http://www.bbc.co.uk/radio/listen/live/r3_aaclca.pls',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','Dance','BBC Radio 1','http://www.bbc.co.uk/radio/listen/live/r1_aaclca.pls',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','Dance','NonStopPlay.com','http://dedi.nonstopplay.co.uk:80',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','News','BBC 5 Live','http://www.bbc.co.uk/radio/listen/live/r5l_aaclca.pls',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','News','BBC Radio 4 Extra','http://www.bbc.co.uk/radio/listen/live/r4x_aaclca.pls',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','News','BBC Radio 4','http://www.bbc.co.uk/radio/listen/live/r4_aaclca.pls',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','News','BBC Radio 4 LW','http://www.bbc.co.uk/radio/listen/live/r4lw_aaclca.pls',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','News','BBC Radio Scotland','http://wmlive.bbc.co.uk/wms/nations/scotland',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','News','BBC Radio Wales','http://wmlive.bbc.co.uk/wms/nations/wales',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','News','BBC World Service','http://www.bbc.co.uk/worldservice/meta/tx/nb/live/eneuk.pls',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','Pop','Capital FM','http://media-ice.musicradio.com:80/CapitalMP3',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('UK','Sport','BBC 5 Live Sports Extra','http://www.bbc.co.uk/radio/listen/live/r5lsp_aaclca.pls',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Ambient','DigitallyImported Ambient','http://205.188.215.228:8006',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Ambient','DigitallyImported Space','http://u11aw.di.fm:80/di_spacemusic',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Chillout','DigitallyImported Chillout Dreams','http://188.72.202.18:8000/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Chillout','DigitallyImported Chillout','http://scfire-dtc-aa02.stream.aol.com:80/stream/1035',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Country','181.fm Kickin Country','http://sc-rly.181.fm:80/stream/1075',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Dance','DigitallyImported Euro Dance','http://scfire-ntc-aa02.stream.aol.com:80/stream/1024',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Dance','DigitallyImported Hard Dance','http://scfire-ntc-aa04.stream.aol.com:80/stream/1025',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Electronic','DigitallyImported DJ Mixes','http://209.247.146.100:8000',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Electronic','DigitallyImported DnB','http://207.200.96.229:8030',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Electronic','DigitallyImported Electronica','http://205.188.215.225:8004',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Electronic','DigitallyImported Gabber','http://205.188.215.226:8006',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Electronic','DigitallyImported Hardstyle','http://u11aw.di.fm:80/di_hardstyle',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Electronic','DigitallyImported Lounge','http://scfire-ntc-aa02.stream.aol.com:80/stream/1009',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Electronic','DigitallyImported Synthpop','http://80.94.69.106:6234/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','House','DigitallyImported Electro House','http://scfire-dtc-aa03.stream.aol.com:80/stream/1025',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','House','DigitallyImported House','http://scfire-mtc-aa01.stream.aol.com:80/stream/1007',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','House','DigitallyImported Soulful House','http://205.188.215.232:8016',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','House','DigitallyImported Tribal House','http://80.94.69.106:6274/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Progressive','Beyond Ear Candy','http://216.66.69.100:6294/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Techno','DigitallyImported Progressive','http://scfire-ntc-aa04.stream.aol.com:80/stream/1026',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Techno','DigitallyImported Techno','http://209.247.146.98:8000/',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Trance','1.FM Amsterdam Trance Radio','mms://atr.1.fm/1fmatr128k',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Trance','DigitallyImported Breaks','http://205.188.215.225:8002',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Trance','DigitallyImported Goa-Psy Trance','http://scfire-ntc-aa04.stream.aol.com:80/stream/1008',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Trance','DigitallyImported Trance','http://scfire-dtc-aa01.stream.aol.com:80/stream/1003',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Trance','DigitallyImported Vocal Trance','http://scfire-ntc-aa04.stream.aol.com:80/stream/1065',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Trance','TranceFM DJ','http://nl01.dj.trance.fm/128',0);"));
    query.exec(QString("INSERT INTO \"stations\" VALUES('USA','Trance','TranceFM','http://nl01.tc.trance.fm/128',0);"));

}



QString StationsDB::getStationName(QString url)
{
    QSqlQuery query( db );
    query.exec(QString("SELECT name FROM stations WHERE url='%1'").arg(url)) ;
    query.next();

    return query.value(0).toString();

}

QString StationsDB::getStationGenre(QString url)
{
    QSqlQuery query( db );
    query.exec(QString("SELECT genre FROM stations WHERE url='%1'").arg(url)) ;
    query.next();

    return query.value(0).toString();
}

QString StationsDB::getStationCountry(QString url)
{
    QSqlQuery query( db );
    query.exec(QString("SELECT country FROM stations WHERE url='%1'").arg(url)) ;
    query.next();

    return query.value(0).toString();
}
