#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    setIcons();
    adjustSize();
    readSettings();

    labelBox.setFixedHeight(50);
    labelBox.setAlignment(Qt::AlignCenter);
    infoBox.setWidget(&labelBox);

    //setAttribute(Qt::WA_DeleteOnClose);
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::setIcons()
{
    ui->icon1Button->setIcon(QIcon("/opt/internetradioplayer/icons/icon1.png"));
    ui->icon2Button->setIcon(QIcon("/opt/internetradioplayer/icons/icon2.png"));
}

void SettingsDialog::on_icon2Button_clicked()
{
    system( "echo 'cp /opt/internetradioplayer/icons/icon2.png /usr/share/icons/hicolor/64x64/apps/internetradioplayer.png' | root" );
    labelBox.setText(tr("Icon changed"));
    infoBox.show();
}

void SettingsDialog::on_icon1Button_clicked()
{
    system( "echo 'cp /opt/internetradioplayer/icons/icon1.png /usr/share/icons/hicolor/64x64/apps/internetradioplayer.png' | root" );
    labelBox.setText(tr("Icon changed"));
    infoBox.show();
}

void SettingsDialog::readSettings()
{
    QSettings settings("internetradioplayer", "settings");
    hideWhenClosing = settings.value("hideWhenClosing", true).toBool();
    showNotifications = settings.value("showNotifications", true ).toBool();
    showNotificationsOnlyWhenScreenIsOn = settings.value("showNotificationsOnlyWhenScreenIsOn", true ).toBool();
    showNotificationsOnlyWhenWindowIsActiveOrViewNotPlayingNow = settings.value("showNotificationsOnlyWhenWindowIsActiveOrViewNotPlayingNow", true ).toBool();

    ui->hideWhenClosingCheckBox->setChecked(hideWhenClosing);

    if ( !showNotifications )
    {
        ui->showNotificationsOnlyWhenScreenIsOnCheckBox->setEnabled(false);
        ui->showNotificationsOnlyWhenWindowIsActiveOrViewNotPlayingNowCheckBox->setEnabled(false);
    }

    ui->showNotificationsCheckBox->setChecked(showNotifications);
    ui->showNotificationsOnlyWhenScreenIsOnCheckBox->setChecked(showNotificationsOnlyWhenScreenIsOn);
    ui->showNotificationsOnlyWhenWindowIsActiveOrViewNotPlayingNowCheckBox->setChecked(showNotificationsOnlyWhenWindowIsActiveOrViewNotPlayingNow);
}

void SettingsDialog::on_saveButton_clicked()
{
    saveSettings();
    emit saveButtonClicked();
    close();
}

void SettingsDialog::saveSettings()
{
    QSettings settings("internetradioplayer", "settings");

    settings.setValue( "hideWhenClosing", ui->hideWhenClosingCheckBox->isChecked() );
    settings.setValue( "showNotifications", ui->showNotificationsCheckBox->isChecked() );
    settings.setValue( "showNotificationsOnlyWhenScreenIs", ui->showNotificationsOnlyWhenScreenIsOnCheckBox->isChecked() );
    settings.setValue( "showNotificationsOnlyWhenWindowIsActiveOrViewNotPlayingNow", ui->showNotificationsOnlyWhenWindowIsActiveOrViewNotPlayingNowCheckBox->isChecked() );

}
