#include <QtGui/QApplication>
#include "mainwindow.h"

#include <QDebug>
#include <QTranslator>


int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QPixmap pixmap(300, 43);
    QSplashScreen splash(pixmap);
    splash.show();
    splash.showMessage("Loading translation", Qt::AlignHCenter, Qt::white);

    QString locale = QLocale::system().name();
    qDebug()<<"locale: "<<locale;
    QTranslator translator;
    qDebug()<<"Translating: "<<translator.load(QString("/opt/internetradioplayer/translations/internetradioplayer_") + locale +QString(".qm"));
    a.installTranslator(&translator);

    a.setApplicationName("InternetRadioPlayer");
    a.setOrganizationName("GGiovanni88");

    splash.showMessage("Loading interface", Qt::AlignHCenter, Qt::white);

    MainWindow w;
    splash.showMessage("Loading stations", Qt::AlignHCenter, Qt::white);
    w.loadStationsList();
    w.populateList();

    splash.showMessage("Settings dbus connections", Qt::AlignHCenter, Qt::white);

    if (!QDBusConnection::sessionBus().isConnected()) {
        qWarning("Cannot connect to the D-Bus session bus.");
        exit(1);
    }

    if (!QDBusConnection::sessionBus().registerService("it.ggiovanni.internetradioplayer")) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
            message()));
        exit(2);
    }

    if (!QDBusConnection::sessionBus().registerObject("/it/ggiovanni/internetradioplayer", &w,
            QDBusConnection::ExportScriptableSlots)) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
            message()));
        exit(3);
    }

    w.show();
    splash.finish(&w);


    return a.exec();
}
