#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    setIcons();
    adjustSize();
    readSettings();

    labelBox.setFixedHeight(50);
    labelBox.setAlignment(Qt::AlignCenter);
    infoBox.setWidget(&labelBox);

    //setAttribute(Qt::WA_DeleteOnClose);
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::setIcons()
{
    ui->icon1Button->setIcon(QIcon("/opt/internetradioplayer/icons/icon1.png"));
    ui->icon2Button->setIcon(QIcon("/opt/internetradioplayer/icons/icon2.png"));
}

void SettingsDialog::on_icon2Button_clicked()
{
    system( "echo 'cp /opt/internetradioplayer/icons/icon2.png /usr/share/icons/hicolor/64x64/apps/internetradioplayer.png' | root" );
    labelBox.setText(tr("Icon changed"));
    infoBox.show();
}

void SettingsDialog::on_icon1Button_clicked()
{
    system( "echo 'cp /opt/internetradioplayer/icons/icon1.png /usr/share/icons/hicolor/64x64/apps/internetradioplayer.png' | root" );
    labelBox.setText(tr("Icon changed"));
    infoBox.show();
}

void SettingsDialog::readSettings()
{
    QSettings settings("InternetRadioPlayer", "Settings");
    hideWhenClosing = settings.value("hideWhenClosing", true).toBool();

    ui->hideWhenClosingCheckBox->setChecked(hideWhenClosing);
}

void SettingsDialog::on_pushButton_clicked()
{
    saveSettings();
    close();
}

void SettingsDialog::saveSettings()
{
    QSettings settings("InternetRadioPlayer", "Settings");

    hideWhenClosing = ui->hideWhenClosingCheckBox->isChecked();
    settings.setValue("hideWhenClosing", hideWhenClosing);
}
