#ifndef STATIONSDB_H
#define STATIONSDB_H

#include <QDebug>
#include <QDir>
#include <QtSql>

class StationsDB
{
public:
    enum OrderBy { OrderByName, OrderByGenre, OrderByCountry };

    StationsDB();

    QStringList getFullStationList(OrderBy orderBy);
    QStringList getGenreList();
    QStringList getCountryList();
    QStringList getListFilteredByGenre(QString filter, OrderBy orderBy);
    QStringList getListFilteredByCountry(QString filter, OrderBy orderBy);
    void checkDB();
    void clearDB();
    void restoreDefaultDB();
    void addDefaultStations();
    void initDB();
    void insertStation(QString name, QString url, QString genre, QString country);
    void deleteStation(QString url);
    void updateStation(QString currentUrl, QString name, QString url, QString genre, QString country);
    void setFavourite(QString url, bool choice);
    QStringList getFavouriteList();

private:
    QSqlDatabase db;



};

#endif // STATIONSDB_H
