#ifndef STATIONSDB_H
#define STATIONSDB_H

#include <QDebug>
#include <QDir>
#include <QtSql>

class StationsDB
{
public:
    StationsDB();

    QStringList getFullStationList();
    QStringList getGenreList();
    QStringList getCountryList();
    QStringList getListFilteredByGenre(QString filter);
    QStringList getListFilteredByCountry(QString filter);
    void checkDB();
    void clearDB();
    void restoreDefaultDB();
    void initDB();
    void insertStation(QString name, QString url, QString genre, QString country);
    void deleteStation(QString url);
    void updateStation(QString currentUrl, QString name, QString url, QString genre, QString country);

private:
    QSqlDatabase db;



};

#endif // STATIONSDB_H
