#!/usr/bin/env python
# -*- coding: utf-8 -*-
# gconftool-2 -s -t int /apps/osso/xterm/font_size 16

import sys
import os
import time
from PyQt4 import QtCore
from PyQt4 import QtGui
from PyQt4.QtCore import Qt
from PyQt4.QtGui import QApplication


greekSymbols = ["alpha", "beta", "chi", "delta", "Delta", "epsilon", "eta", "gamma", "Gamma", "iota", "kappa", "nu", "omega", "Omega", "omicron", "phi", "Phi", "pi", "Pi", "psi", "Psi", "rho", "sigma", "Sigma", "tau", "theta", "upsilon", "xi", "Xi"]

sympy_symbols_functions = ["acos()", "acosh()", "acot()", "acoth()", "asin()", "asinh()", "atan()", "atanh()", "cos()", "cosh()", "cot()", "coth()", "DiracDelta()", "E", "EulerGamma", "exp()", "factorial()", "fibonacci()", "gamma()", "GoldenRatio", "harmonic()", "hermite(n,x)", "I", "im()", "legendre(n,x)", "ln()", "ln(n,b)", "log()", "log(n,b)", "oo", "re()", "sin()", "sinh()", "sqrt()", "tan()", "tanh()", "zeta()"]

historyIntegrandSamples = ["1/(alpha*x+beta)**3","1/sqrt(alpha*x+beta)","log(sigma*x)**2","sin(kappa*x)**5", "x**3/(alpha*x**2+beta)**2", "exp(omega*t**2)*t"]

historyLimitSamples = ["pi/2","-pi/2","pi/3","-pi/3","pi/4","-pi/4","pi/6","-pi/6","-pi","-oo","0","1","-1"]


class IntegralWindow(QtGui.QMainWindow):
    def __init__(self, parent=None):
        QtGui.QMainWindow.__init__(self, parent)
        self.setWindowTitle("Integral")

        self.window = QtGui.QWidget()
        self.setCentralWidget(self.window)
        try:
            self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
            self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
            self.isMaemo5 = True
        except:
            self.isMaemo5 = False

        if self.isMaemo5:
            # Set monospace font so math text is correctly shown.
            os.system('gconftool-2 -s -t string /apps/osso/xterm/font_name \"Monospace\"')
            # Large font size for xterm so it is better visible and the line breaks work ok.
            os.system("gconftool-2 -s -t int /apps/osso/xterm/font_size 16")

        if not self.isMaemo5:
            self.resize(800, 600)

        self.settings = QtCore.QSettings()
        self.loadSettings()

        self.historyInitIntegrand = QtCore.QStringList()
        for i in greekSymbols+sympy_symbols_functions+historyIntegrandSamples:
            self.historyInitIntegrand.append(QtCore.QString(i))
        self.historyIntegrand=self.historyInitIntegrand+self.historyUserIntegrand

        self.historyInitLimits = QtCore.QStringList()
        for i in greekSymbols+sympy_symbols_functions+historyLimitSamples:
            self.historyInitLimits.append(QtCore.QString(i))
        self.historyLimits=self.historyInitLimits+self.historyUserLimits

        self.historyDifferentials = QtCore.QStringList()
        for i in greekSymbols:
            self.historyDifferentials.append(QtCore.QString(i))

        self.nonCalculatedIntegral = ""
        self.resultIntegral = ""
        self.timeIntegral = 0.0
        self.configUpdateResult = False
        self.createMenuAndActions()
        self.createItems()
        self.showHideItems()
        self.createLayouts()

    def createItems(self):
        self.integrandEditCompleter = QtGui.QCompleter()
        self.integrandEditCompleter.setCaseSensitivity(QtCore.Qt.CaseInsensitive)
        self.integrandEditModel = QtGui.QStringListModel()
        self.integrandEditCompleter.setModel(self.integrandEditModel)
        self.integrandEditModel.setStringList(self.historyIntegrand)

        self.integrandLabel = QtGui.QLabel(self.tr("Integrand"))
        self.integrandEdit = QtGui.QLineEdit("")
        self.integrandEdit.setCompleter(self.integrandEditCompleter)

        self.diffEditCompleter = QtGui.QCompleter()
        self.diffEditCompleter.setCaseSensitivity(QtCore.Qt.CaseInsensitive)
        self.diffEditModel = QtGui.QStringListModel()
        self.diffEditCompleter.setModel(self.diffEditModel)
        self.diffEditModel.setStringList(self.historyDifferentials)

        self.diff1Label = QtGui.QLabel("d")
        self.diff1Edit = QtGui.QLineEdit("x")
        self.diff1Edit.setMaximumSize(QtCore.QSize(80,100))
        self.diff1Edit.setCompleter(self.diffEditCompleter)
        self.diff2Label = QtGui.QLabel("d")
        self.diff2Edit = QtGui.QLineEdit("y")
        self.diff2Edit.setMaximumSize(QtCore.QSize(80,100))
        self.diff2Edit.setCompleter(self.diffEditCompleter)
        self.diff3Label = QtGui.QLabel("d")
        self.diff3Edit = QtGui.QLineEdit("z")
        self.diff3Edit.setMaximumSize(QtCore.QSize(80,100))
        self.diff3Edit.setCompleter(self.diffEditCompleter)

        self.limEditCompleter = QtGui.QCompleter()
        self.limEditCompleter.setCaseSensitivity(QtCore.Qt.CaseInsensitive)
        self.limEditModel = QtGui.QStringListModel()
        self.limEditCompleter.setModel(self.limEditModel)
        self.limEditModel.setStringList(self.historyLimits)

        self.limSupLabel = QtGui.QLabel(self.tr("Upper limit"))
        self.limSup1Edit = QtGui.QLineEdit("1")
        self.limSup1Edit.setCompleter(self.limEditCompleter)
        self.limSup2Edit = QtGui.QLineEdit("1")
        self.limSup2Edit.setCompleter(self.limEditCompleter)
        self.limSup3Edit = QtGui.QLineEdit("1")
        self.limSup3Edit.setCompleter(self.limEditCompleter)
        self.limInfLabel = QtGui.QLabel(self.tr("Lower limit"))
        self.limInf1Edit = QtGui.QLineEdit("0")
        self.limInf1Edit.setCompleter(self.limEditCompleter)
        self.limInf2Edit = QtGui.QLineEdit("0")
        self.limInf2Edit.setCompleter(self.limEditCompleter)
        self.limInf3Edit = QtGui.QLineEdit("0")
        self.limInf3Edit.setCompleter(self.limEditCompleter)

        font = QtGui.QFont()
        font.setFamily("Monospace")
#        font.setFamily("Courier New")
        if self.isMaemo5:
#            font.setPointSize(8)  # 98 columns term mono10
#            font.setPointSize(10)  # 79 columns term mono10
#            font.setPointSize(12)  # 71 columns term mono10
#            font.setBold(True)
            font.setPointSize(16)  # 56 columns term mono10
        else:
            font.setPointSize(10)  # 79 columns term mono10
        self.resultEdit = QtGui.QTextBrowser()
#        self.resultEdit = QtGui.QTextEdit()
        self.resultEdit.setReadOnly(False)
        self.resultEdit.setFont(font)

        # Connect buttons
        self.connect(self.limSup1Edit,QtCore.SIGNAL("returnPressed()"),self.updateHistoriesAndResult)
        self.connect(self.limSup2Edit,QtCore.SIGNAL("returnPressed()"),self.updateHistoriesAndResult)
        self.connect(self.limSup3Edit,QtCore.SIGNAL("returnPressed()"),self.updateHistoriesAndResult)
        self.connect(self.diff1Edit,QtCore.SIGNAL("returnPressed()"),self.updateHistoriesAndResult)
        self.connect(self.diff2Edit,QtCore.SIGNAL("returnPressed()"),self.updateHistoriesAndResult)
        self.connect(self.diff3Edit,QtCore.SIGNAL("returnPressed()"),self.updateHistoriesAndResult)
        self.connect(self.limInf1Edit,QtCore.SIGNAL("returnPressed()"),self.updateHistoriesAndResult)
        self.connect(self.limInf2Edit,QtCore.SIGNAL("returnPressed()"),self.updateHistoriesAndResult)
        self.connect(self.limInf3Edit,QtCore.SIGNAL("returnPressed()"),self.updateHistoriesAndResult)
        self.connect(self.integrandEdit,QtCore.SIGNAL("returnPressed()"),self.updateHistoriesAndResult)

    def createLayouts(self):    
        self.h_box_limSup = QtGui.QHBoxLayout()
        self.h_box_limSup.addWidget(self.limSupLabel)
        self.h_box_limSup.addWidget(self.limSup3Edit)
        self.h_box_limSup.addWidget(self.limSup2Edit)
        self.h_box_limSup.addWidget(self.limSup1Edit)
        self.h_box_integrand = QtGui.QHBoxLayout()
        self.h_box_integrand.addWidget(self.integrandLabel)
        self.h_box_integrand.addWidget(self.integrandEdit)
        self.h_box_integrand.addWidget(self.diff1Label)
        self.h_box_integrand.addWidget(self.diff1Edit)
        self.h_box_integrand.addWidget(self.diff2Label)
        self.h_box_integrand.addWidget(self.diff2Edit)
        self.h_box_integrand.addWidget(self.diff3Label)
        self.h_box_integrand.addWidget(self.diff3Edit)
        self.h_box_limInf = QtGui.QHBoxLayout()
        self.h_box_limInf.addWidget(self.limInfLabel)
        self.h_box_limInf.addWidget(self.limInf3Edit)
        self.h_box_limInf.addWidget(self.limInf2Edit)
        self.h_box_limInf.addWidget(self.limInf1Edit)
        self.v_box = QtGui.QVBoxLayout()
        self.v_box.addLayout(self.h_box_limSup)
        self.v_box.addLayout(self.h_box_integrand)
        self.v_box.addLayout(self.h_box_limInf)
        self.v_box.addWidget(self.resultEdit)
        self.window.setLayout(self.v_box)
        
    def showHideItems(self):
        if self.typeIntegral == 1:
            self.limSupLabel.hide()
            self.limSup1Edit.hide()
    	    self.limSup2Edit.hide()
    	    self.limSup3Edit.hide()
            self.limInfLabel.hide()
            self.limInf1Edit.hide()
    	    self.limInf2Edit.hide()
    	    self.limInf3Edit.hide()
        else:
            self.limSupLabel.show()
            self.limSup1Edit.show()
            self.limInfLabel.show()
            self.limInf1Edit.show()
            if self.numDimensions > 1:
        	    self.limSup2Edit.show()
        	    self.limInf2Edit.show()
            else:
        	    self.limSup2Edit.hide()
        	    self.limInf2Edit.hide()
            if self.numDimensions > 2:
        	    self.limSup3Edit.show()
        	    self.limInf3Edit.show()
            else:
        	    self.limSup3Edit.hide()
        	    self.limInf3Edit.hide()
        if self.numDimensions > 1:
            self.diff2Label.show()
            self.diff2Edit.show()
        else:
           self.diff2Label.hide()
           self.diff2Edit.hide()
        if self.numDimensions > 2:
            self.diff3Label.show()
            self.diff3Edit.show()
        else:
           self.diff3Label.hide()
           self.diff3Edit.hide()

    def createMenuAndActions(self):
        fileMenu = self.menuBar().addMenu(self.tr("&File"))
#        saveAction = fileMenu.addAction(self.tr("&Salvar"))
#        shareAction = fileMenu.addAction(self.tr("&Share"))
        if not self.isMaemo5:
            fileMenu.addSeparator()
            exitAction = fileMenu.addAction(self.tr("&Quit"))
        
        integralMenu = self.menuBar().addMenu(self.tr("&Integral"))
        undefinedAction = QtGui.QAction(self.tr("Indefinite"), self, checkable=True)
        definedAction = QtGui.QAction(self.tr("Definite"), self, checkable=True)
        numericalAction = QtGui.QAction(self.tr("Numerical"), self, checkable=True)
        typeIntegralGroup = QtGui.QActionGroup(self)
        typeIntegralGroup.addAction(undefinedAction)
        typeIntegralGroup.addAction(definedAction)
        typeIntegralGroup.addAction(numericalAction)
        if self.typeIntegral == 1:
            undefinedAction.setChecked(True)
        elif self.typeIntegral == 2:
            definedAction.setChecked(True)
        else:
            numericalAction.setChecked(True)     
        integralMenu.addAction(undefinedAction)
        integralMenu.addAction(definedAction)
        integralMenu.addAction(numericalAction)
        integralMenu.addSeparator()
        n1DAction = QtGui.QAction("1D", self, checkable=True)
        n2DAction = QtGui.QAction("2D", self, checkable=True)
        n3DAction = QtGui.QAction("3D", self, checkable=True)
        dimIntegralGroup = QtGui.QActionGroup(self)
        dimIntegralGroup.addAction(n1DAction)
        dimIntegralGroup.addAction(n2DAction)
        dimIntegralGroup.addAction(n3DAction)
        if self.numDimensions == 1:
            n1DAction.setChecked(True)
        elif self.numDimensions == 2:
            n2DAction.setChecked(True)
        else:
            n3DAction.setChecked(True)
        integralMenu.addAction(n1DAction)
        integralMenu.addAction(n2DAction)
        integralMenu.addAction(n3DAction)
        integralMenu.addSeparator()
        configAction = integralMenu.addAction(self.tr("Settings"))

        helpMenu = self.menuBar().addMenu(self.tr("Help"))
#        helpAction = helpMenu.addAction(self.tr("Help"))
        helpMenu.addSeparator()
        aboutAction = helpMenu.addAction(self.tr("&About"))

        self.connect(undefinedAction, QtCore.SIGNAL("triggered()"), self.undefinedMenu)
        self.connect(definedAction, QtCore.SIGNAL("triggered()"), self.definedMenu)
        self.connect(numericalAction, QtCore.SIGNAL("triggered()"), self.numericalMenu)
        self.connect(n1DAction, QtCore.SIGNAL("triggered()"), self.n1DMenu)
        self.connect(n2DAction, QtCore.SIGNAL("triggered()"), self.n2DMenu)
        self.connect(n3DAction, QtCore.SIGNAL("triggered()"), self.n3DMenu)
        if not self.isMaemo5:
            self.connect(exitAction, QtCore.SIGNAL("triggered()"), app, QtCore.SLOT("quit()"))
        self.connect(configAction, QtCore.SIGNAL("triggered()"), self.showConfigWindow)
        self.connect(aboutAction, QtCore.SIGNAL("triggered()"), self.showAboutBox)

    def showAboutBox(self):
        versionIntegral = '1.0.0'
        siteIntegral = 'http://www.RobertoColistete.net/Integral\n'
        infoIntegral = self.tr("Calculation of integrals using ")
        infoPython = "Python v"+python_version()
        infoSymPy = " - Sympy v"+__version__
        QtGui.QMessageBox.information(self, self.tr("About Integral"),
            'Integral v'+versionIntegral+' (C) 2011 Roberto Colistete Jr.\n'+siteIntegral+infoIntegral+infoPython+infoSymPy)

    def showConfigWindow(self):
        self.configWin = QtGui.QMainWindow(self)
        if self.isMaemo5:
            self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
            self.configWin.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.configWin.setWindowTitle(self.tr("Integral (Settings)"))
        self.configWin.window = QtGui.QWidget()
        self.configWin.setCentralWidget(self.configWin.window)
        self.configWin.v_box = QtGui.QVBoxLayout()

        self.configUpdateResult = False

        self.configWin.showIntegralCheckBox = QtGui.QCheckBox(self.tr("Show not calculated integral before result"))
        if self.showIntegral:
            self.configWin.showIntegralCheckBox.toggle()

        self.configWin.showTimeCheckBox = QtGui.QCheckBox(self.tr("Show calculation time before integral result"))
        if self.showTime:
            self.configWin.showTimeCheckBox.toggle()

        self.configWin.h_box_simplify = QtGui.QHBoxLayout()
        self.configWin.simplifyLabel = QtGui.QLabel(self.tr("Simplification for non-numerical integration"))
        self.configWin.simplifySpacer = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding,\
                                                          QtGui.QSizePolicy.Minimum)
        self.configWin.simplifyComboBox = QtGui.QComboBox()
        self.configWin.simplifyComboBox.addItem(self.tr("None"))
        self.configWin.simplifyComboBox.addItem(self.tr("Term by term"))
        self.configWin.simplifyComboBox.addItem(self.tr("Whole expression"))
        self.configWin.simplifyComboBox.setCurrentIndex(self.simplifyResult)
        self.configWin.h_box_simplify.addWidget(self.configWin.simplifyLabel)
        self.configWin.h_box_simplify.addWidget(self.configWin.simplifyComboBox)
        self.configWin.h_box_simplify.addItem(self.configWin.simplifySpacer)

        self.configWin.h_box_output = QtGui.QHBoxLayout()
        self.configWin.outputLabel = QtGui.QLabel(self.tr("Output type for integral result"))
        self.configWin.outputSpacer = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.configWin.outputComboBox = QtGui.QComboBox()
        self.configWin.outputComboBox.addItem(self.tr("Simple"))
        self.configWin.outputComboBox.addItem(self.tr("Bidimensional"))
        self.configWin.outputComboBox.addItem(self.tr("Typesetting"))
        self.configWin.outputComboBox.addItem("LaTex")
        self.configWin.outputComboBox.addItem("MathML")
        self.configWin.outputComboBox.addItem("C")
        self.configWin.outputComboBox.setCurrentIndex(self.outputResult)
        self.configWin.h_box_output.addWidget(self.configWin.outputLabel)
        self.configWin.h_box_output.addWidget(self.configWin.outputComboBox)
        self.configWin.h_box_output.addItem(self.configWin.outputSpacer)

        self.configWin.h_box_numDig = QtGui.QHBoxLayout()
        self.configWin.numDigLabel = QtGui.QLabel(self.tr("Number of digits for numerical integration"))
        self.configWin.numDigSpacer = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.configWin.numDigEdit = QtGui.QLineEdit(str(self.numDig))
        self.configWin.numDigEdit.setValidator(QtGui.QIntValidator(1,1000000,self.configWin.numDigEdit))
        self.configWin.numDigEdit.setMaximumSize(QtCore.QSize(100,100))
        self.configWin.h_box_numDig.addWidget(self.configWin.numDigLabel)
        self.configWin.h_box_numDig.addWidget(self.configWin.numDigEdit)
        self.configWin.h_box_numDig.addItem(self.configWin.numDigSpacer)

        self.configWin.h_box_numerInt = QtGui.QHBoxLayout()
        self.configWin.numerIntLabel = QtGui.QLabel(self.tr("Numerical integration method"))
        self.configWin.numerIntSpacer = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding,\
                                                          QtGui.QSizePolicy.Minimum)
        self.configWin.numerIntComboBox = QtGui.QComboBox()
        self.configWin.numerIntComboBox.addItem(self.tr("Numerical approximation of definite integral"))
        self.configWin.numerIntComboBox.addItem(self.tr("Optimized for infinities"))
        self.configWin.numerIntComboBox.addItem(self.tr("Optimized for smooth integrands"))
        self.configWin.numerIntComboBox.setCurrentIndex(self.numerIntegralType)
        self.configWin.h_box_numerInt.addWidget(self.configWin.numerIntLabel)
        self.configWin.h_box_numerInt.addWidget(self.configWin.numerIntComboBox)
        self.configWin.h_box_numerInt.addItem(self.configWin.numerIntSpacer)

        self.configWin.v_box.addWidget(self.configWin.showIntegralCheckBox)
        self.configWin.v_box.addWidget(self.configWin.showTimeCheckBox)
        self.configWin.v_box.addLayout(self.configWin.h_box_simplify)
        self.configWin.v_box.addLayout(self.configWin.h_box_output)
        self.configWin.v_box.addLayout(self.configWin.h_box_numDig)
        self.configWin.v_box.addLayout(self.configWin.h_box_numerInt)
        self.configWin.window.setLayout(self.configWin.v_box)

        self.connect(self.configWin.showIntegralCheckBox, QtCore.SIGNAL("stateChanged(int)"), self.toggleShowIntegral)
        self.connect(self.configWin.showTimeCheckBox, QtCore.SIGNAL("stateChanged(int)"), self.toggleShowTime)
        self.connect(self.configWin.simplifyComboBox, QtCore.SIGNAL("activated(int)"), self.changeSimplifyResult)
        self.connect(self.configWin.outputComboBox, QtCore.SIGNAL("activated(int)"), self.changeOutputResult)
        self.connect(self.configWin.numDigEdit, QtCore.SIGNAL("textEdited (const QString&)"),self.changeNumDig)
        self.connect(self.configWin.numerIntComboBox, QtCore.SIGNAL("activated(int)"), self.changeNumerIntegralType)
#        self.connect(self.configWin, QtCore.SIGNAL('triggered()'), self.closeEvent)
        self.configWin.show()

    def loadSettings(self):
        self.numDimensions = self.settings.value('NumDimensions',1).toInt()[0]
        self.typeIntegral = self.settings.value('TypeIntegral',1).toInt()[0]
        self.showIntegral = self.settings.value('ShowIntegral',True).toBool()
        self.showTime = self.settings.value('ShowTime',True).toBool()
        self.simplifyResult = self.settings.value('SimplifyResult',1).toInt()[0]
        self.outputResult = self.settings.value('OutputResult',1).toInt()[0]
        self.numDig = self.settings.value('NumDig',15).toInt()[0]
        self.numerIntegralType = self.settings.value('NumerIntegralType',1).toInt()[0]
        self.historyUserIntegrand = self.settings.value('HistoryUserIntegrand','').toStringList()
        self.historyUserLimits = self.settings.value('HistoryUserLimits','').toStringList()

    def saveSettings(self):
        self.settings.setValue('NumDimensions',self.numDimensions)
        self.settings.setValue('TypeIntegral',self.typeIntegral) 	
        self.settings.setValue('ShowIntegral',self.showIntegral) 	
        self.settings.setValue('ShowTime',self.showTime) 	
        self.settings.setValue('SimplifyResult',self.simplifyResult)
        self.settings.setValue('OutputResult',self.outputResult)
        self.settings.setValue('NumDig',self.numDig)
        self.settings.setValue('NumerIntegralType',self.numerIntegralType)
        self.settings.setValue('HistoryUserIntegrand',self.historyUserIntegrand)
        self.settings.setValue('HistoryUserLimits',self.historyUserLimits)

#    def closeEvent(self, event):
#        if self.configUpdateResult:
#            print "Saindo do Config com update"
#            self.updateResult(False)
#        else:
#            print "Saindo do Config sem update"
#        self.deleteLater()

    def toggleShowIntegral(self, status):
        if status == Qt.Checked:
            self.showIntegral = True
        else:
            self.showIntegral = False
        self.updateResult(False)
        self.configUpdateResult = True
        self.saveSettings()

    def toggleShowTime(self, status):
        if status == Qt.Checked:
            self.showTime = True
        else:
            self.showTime = False
        self.updateResult(False)
        self.configUpdateResult = True
        self.saveSettings()

    def changeSimplifyResult(self, option):
        self.simplifyResult = option
        self.updateResult(False)
        self.configUpdateResult = True
        self.saveSettings()

    def changeOutputResult(self, option):
        self.outputResult = option
        self.updateResult(False)
        self.configUpdateResult = True
        self.saveSettings()

    def changeNumerIntegralType(self, option):
        self.numerIntegralType = option
        self.saveSettings()

    def changeNumDig(self):
        if self.configWin.numDigEdit.text():
            self.numDig = int(self.configWin.numDigEdit.text())
        else:
            self.numDig = 0
        self.saveSettings()

    def undefinedMenu(self):
        self.typeIntegral = 1
        self.showHideItems()
        self.saveSettings()

    def definedMenu(self):
        self.typeIntegral = 2	
        self.showHideItems()
        self.saveSettings()

    def numericalMenu(self):
        self.typeIntegral = 3
        self.showHideItems()
        self.saveSettings()

    def n1DMenu(self):
        self.numDimensions = 1
        self.showHideItems()
        self.saveSettings()

    def n2DMenu(self):
        self.numDimensions = 2
        self.showHideItems()
        self.saveSettings()

    def n3DMenu(self):
        self.numDimensions = 3
        self.showHideItems()
        self.saveSettings()

    def mapexpr(self,expr,func):
        if isinstance(expr,Add):
            return apply(Add,map(func,expr.args))
        else:
            return func(expr)

    def updateHistoriesAndResult(self):
        text = unicode(self.integrandEdit.text())
        if not text in self.historyIntegrand:
            self.historyUserIntegrand.prepend(text)
            self.historyUserIntegrand=self.historyUserIntegrand[:100]
            self.historyIntegrand=self.historyInitIntegrand+self.historyUserIntegrand
            self.integrandEditModel.setStringList(self.historyIntegrand)
        text = unicode(self.diff1Edit.text())
        if not text in self.historyDifferentials:
            self.historyDifferentials.prepend(text)
            self.diffEditModel.setStringList(self.historyDifferentials)
        text = unicode(self.diff2Edit.text())
        if not text in self.historyDifferentials:
            self.historyDifferentials.prepend(text)
            self.diffEditModel.setStringList(self.historyDifferentials)
        text = unicode(self.diff3Edit.text())
        if not text in self.historyDifferentials:
            self.historyDifferentials.prepend(text)
            self.diffEditModel.setStringList(self.historyDifferentials)
        text = unicode(self.limSup1Edit.text())
        if not text in self.historyLimits:
            self.historyUserLimits.prepend(text)
            self.historyUserLimits=self.historyUserLimits[:100]
            self.historyLimits=self.historyInitLimits+self.historyUserLimits
            self.limEditModel.setStringList(self.historyLimits)
        text = unicode(self.limSup2Edit.text())
        if not text in self.historyLimits:
            self.historyUserLimits.prepend(text)
            self.historyUserLimits=self.historyUserLimits[:100]
            self.historyLimits=self.historyInitLimits+self.historyUserLimits
            self.limEditModel.setStringList(self.historyLimits)
        text = unicode(self.limSup3Edit.text())
        if not text in self.historyLimits:
            self.historyUserLimits.prepend(text)
            self.historyUserLimits=self.historyUserLimits[:100]
            self.historyLimits=self.historyInitLimits+self.historyUserLimits
            self.limEditModel.setStringList(self.historyLimits)
        text = unicode(self.limInf1Edit.text())
        if not text in self.historyLimits:
            self.historyUserLimits.prepend(text)
            self.historyUserLimits=self.historyUserLimits[:100]
            self.historyLimits=self.historyInitLimits+self.historyUserLimits
            self.limEditModel.setStringList(self.historyLimits)
        text = unicode(self.limInf2Edit.text())
        if not text in self.historyLimits:
            self.historyUserLimits.prepend(text)
            self.historyUserLimits=self.historyUserLimits[:100]
            self.historyLimits=self.historyInitLimits+self.historyUserLimits
            self.limEditModel.setStringList(self.historyLimits)
        text = unicode(self.limInf3Edit.text())
        if not text in self.historyLimits:
            self.historyUserLimits.prepend(text)
            self.historyUserLimits=self.historyUserLimits[:100]
            self.historyLimits=self.historyInitLimits+self.historyUserLimits
            self.limEditModel.setStringList(self.historyLimits)
        self.saveSettings()
        self.updateResult()

    def updateResult(self, flagCalculate=True):
        if flagCalculate:
            if self.isMaemo5:
                self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator,True)
                QApplication.processEvents()
    	    timet1=time.time()
            integrand = unicode(self.integrandEdit.text())
            diffvar1 = self.diff1Edit.text()
            if self.numDimensions > 1:
                diffvar2 = unicode(self.diff2Edit.text())
            if self.numDimensions > 2:
                diffvar3 = unicode(self.diff3Edit.text())
            if self.typeIntegral > 1:
                limSup1 = unicode(self.limSup1Edit.text())
                limInf1 = unicode(self.limInf1Edit.text())
                if self.numDimensions > 1:
                    limSup2 = unicode(self.limSup2Edit.text())
                    limInf2 = unicode(self.limInf2Edit.text())
                if self.numDimensions > 2:
                    limSup3 = unicode(self.limSup3Edit.text())
                    limInf3 = unicode(self.limInf3Edit.text())
            integrateExpr = '('+integrand+','
            if self.typeIntegral == 1:
                integrateExpr += diffvar1
                if self.numDimensions > 1:
                    integrateExpr += ','+diffvar2
                if self.numDimensions > 2:
                    integrateExpr += ','+diffvar3
                integrateExpr += ')'
                try:
                    self.nonCalculatedIntegral = sympify('Integral'+integrateExpr)
                except:
                    self.nonCalculatedIntegral = ''
                try:
                    self.resultIntegral = sympify('integrate'+integrateExpr)
                except:
                    self.resultIntegral = ''
            elif self.typeIntegral == 2:
                integrateExpr += '('+diffvar1+','+limInf1+','+limSup1+')'
                if self.numDimensions > 1:
                    integrateExpr += ',('+diffvar2+','+limInf2+','+limSup2+')'
                if self.numDimensions > 2:
                    integrateExpr += ',('+diffvar3+','+limInf3+','+limSup3+')'
                integrateExpr += ')'
                try:
                    self.nonCalculatedIntegral = sympify('Integral'+integrateExpr)
                except:
                    self.nonCalculatedIntegral = ''
                try:
                    self.resultIntegral = sympify('integrate'+integrateExpr)
                except:
                    self.resultIntegral = ''
            else:
                integrateExpr += '('+diffvar1+','+limInf1+','+limSup1+')'
                if self.numDimensions > 1:
                    integrateExpr += ',('+diffvar2+','+limInf2+','+limSup2+')'
                if self.numDimensions > 2:
                    integrateExpr += ',('+diffvar3+','+limInf3+','+limSup3+')'
                integrateExpr += ')'
                try:
                    self.nonCalculatedIntegral = sympify('Integral'+integrateExpr)
                except:
                    self.nonCalculatedIntegral = ''
                if self.numerIntegralType == 0:
                    try:
                        self.resultIntegral = sympify('N(integrate'+integrateExpr+','+str(self.numDig)+')')
                    except:
                        self.resultIntegral = ''
                else:
                    mp.dps=self.numDig
                    integrateExpr = "(lambda "
                    if self.numDimensions > 2:
                        integrateExpr += diffvar3+","
                    if self.numDimensions > 1:
                        integrateExpr += diffvar2+","
                    integrand = self.fixMPMathText(integrand)
                    integrateExpr += diffvar1+": "+integrand
                    if self.numDimensions > 2:
                        limInf3 = self.fixMPMathText(limInf3)
                        limSup3 = self.fixMPMathText(limSup3)
                        integrateExpr += ',['+limInf3+','+limSup3+']'
                    if self.numDimensions > 1:
                        limInf2 = self.fixMPMathText(limInf2)
                        limSup2 = self.fixMPMathText(limSup2)
                        integrateExpr += ',['+limInf2+','+limSup2+']'
                    limInf1 = self.fixMPMathText(limInf1)
                    limSup1 = self.fixMPMathText(limSup1)
                    integrateExpr += ",["+limInf1+","+limSup1+"])"
                    try:
                        if self.numerIntegralType == 1:
                             self.resultIntegral = eval(str("quadts"+integrateExpr))
                        else:
                            self.resultIntegral = eval(str('quadgl'+integrateExpr))
                    except:
                        self.resultIntegral = ''
                    self.resultIntegral = self.fixMPMathOutput(str(self.resultIntegral))
    	    timet2=time.time()
            self.timeIntegral=timet2-timet1
            if self.isMaemo5:
                self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator,False)
                QApplication.processEvents()
        if (self.resultIntegral) and (self.typeIntegral <= 2):
            if self.simplifyResult == 0:
                resultOutput = sympify(self.resultIntegral)
            elif self.simplifyResult == 1:
                resultOutput = sympify(self.mapexpr(self.resultIntegral,simplify))
            else:
                resultOutput = sympify(simplify(self.resultIntegral))
        else:
            resultOutput = self.resultIntegral
        if self.outputResult == 0:
            nonCalculatedIntegralOutput = self.nonCalculatedIntegral
        elif self.outputResult == 1:
            nonCalculatedIntegralOutput = self.fixUnicodeTextMaemo5(printing.pretty(self.nonCalculatedIntegral))
            resultOutput = self.fixUnicodeTextMaemo5(printing.pretty(resultOutput))
        elif self.outputResult == 2:
            nonCalculatedIntegralOutput = printing.pretty(self.nonCalculatedIntegral)
            resultOutput = printing.pretty(resultOutput)
        elif self.outputResult == 3:
            nonCalculatedIntegralOutput = latex(self.nonCalculatedIntegral)
            resultOutput = latex(resultOutput)
        elif self.outputResult == 4:
            nonCalculatedIntegralOutput = mathml(self.nonCalculatedIntegral)
            resultOutput = mathml(resultOutput)
        elif self.outputResult == 5:
            nonCalculatedIntegralOutput = ccode(self.nonCalculatedIntegral)
            resultOutput = ccode(resultOutput)
        self.resultEdit.clear()
        if self.showTime:
            self.resultEdit.append("Calculated after %f seconds :" % self.timeIntegral)
        if self.showIntegral:
            self.resultEdit.append("%s\n=" % nonCalculatedIntegralOutput)
        self.resultEdit.append("%s" % unicode(resultOutput))

    def fixMPMathText(self, str):
        str = str.replace("oo","inf")
        str = str.replace("E","e")
        str = str.replace("I","j")
        str = str.replace("GoldenRatio","phi")
        return str

    def fixMPMathOutput(self, str):
        str = str.replace("j","i")
        return str

    def fixUnicodeTextMaemo5(self, str):
        if self.isMaemo5:
#            str = str.replace(u"⎮","|")
            str = str.replace(u"⎮",u'\u2223')
#            str = str.replace(u"⎜","|")
            str = str.replace(u"⎜",u'\u2223')
#            str = str.replace(u"⎟","|")
            str = str.replace(u"⎟",u'\u2223')
            str = str.replace(u"⎽","_")
#            str = str.replace(u"⎛","/")
            str = str.replace(u"⎛",u"⌈")
#            str = str.replace(u"⎝","\\")
            str = str.replace(u"⎝",u"⌊")
#            str = str.replace(u"⎞","\\")
            str = str.replace(u"⎞",u"⌉")
#            str = str.replace(u"⎠","/")
            str = str.replace(u"⎠",u"⌋")
        str = str.replace(u"ℯ","e")
        str = str.replace(u"ⅈ","i")
        return str


if __name__ == "__main__":
    #This function means this was run directly, not called from another python file.
    app = QtGui.QApplication(sys.argv)
#    app.setOrganizationName("Roberto Colistte Jr.")
    app.setOrganizationDomain("RobertoColistete.net")
    app.setApplicationName("Integral")

    myapp = IntegralWindow()
    myapp.show()
    from platform import python_version
    from sympy import *
    from sympy import __version__
    from sympy.integrals import *
    from sympy.mpmath import *
    from sympy.printing.ccode import ccode
    from sympy.printing.mathml import mathml
    sys.exit(app.exec_())
