#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

DBusConnection *connection;

static void
make_connection (void)
{
  DBusError error;

  dbus_error_init (&error);

  connection = dbus_bus_get (DBUS_BUS_SESSION,
                             &error);

  if (!connection)
    {
      fprintf (stderr, "Error in opening bus: %s\n",
               error.message);
      dbus_error_free (&error);
      exit (255);
    }
}

static void
acquire_service (void)
{
  guint32 code;
  DBusError error;

  dbus_error_init (&error);

  code = dbus_bus_request_name (connection,
                "com.imgur",
                DBUS_NAME_FLAG_ALLOW_REPLACEMENT,
                &error);

  if (dbus_error_is_set (&error))
    {
      fprintf (stderr, "Error in acquiring service: %s\n",
          error.message);
      dbus_error_free (&error);
      exit (255);
    }

  switch (code)
    {
    case DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER:
        printf ("got it\n");
        break;
    case DBUS_REQUEST_NAME_REPLY_IN_QUEUE:
        printf ("reply in queue\n");
        break;
    case DBUS_REQUEST_NAME_REPLY_EXISTS:
	fprintf (stderr, "Problem: service exists\n");
	break;
    case DBUS_REQUEST_NAME_REPLY_ALREADY_OWNER:
        fprintf (stderr, "Problem: already owner\n");
        break;
    default:
        fprintf (stderr, "Problem: unknown error\n");
    }

}

static DBusHandlerResult
handler_func (DBusConnection *connection,
              DBusMessage *message,
              void *user_data)
{
  DBusMessageIter iter;
  int type;

  printf(" --> %s / %s / %s\n",
                  dbus_message_type_to_string (dbus_message_get_type (message)),
		  dbus_message_get_interface(message), dbus_message_get_member(message));

  dbus_message_iter_init (message, &iter);
  while ((type = dbus_message_iter_get_arg_type (&iter)) != DBUS_TYPE_INVALID)
    {
      printf("     --> %d\n", type);
      dbus_message_iter_next (&iter);
    }

  if (dbus_message_is_method_call (message,
      "com.imgur",
      "Upload"))
    {
	    DBusMessage *reply;
	    DBusMessageIter iter2;
            char *foo = "your mum";

	    printf ("Hurrah, a customer\n");
            
            reply = dbus_message_new_method_return (message);

	    dbus_message_iter_init_append (reply, &iter2);
            dbus_message_iter_append_basic (&iter2, DBUS_TYPE_STRING, &foo);

            dbus_connection_send (connection, reply, NULL);
            dbus_message_unref (reply);
    }
  return DBUS_HANDLER_RESULT_HANDLED;
}

static void
wait_for_messages (void)
{
  GMainLoop *loop;
  
  loop = g_main_loop_new (NULL, FALSE);

  dbus_connection_setup_with_g_main (connection, NULL);

  dbus_connection_add_filter (connection, handler_func, NULL, NULL);

  g_main_loop_run (loop);

  dbus_connection_close (connection);
}

int
main (int argc, char **argv)
{
  make_connection ();

  acquire_service ();

  wait_for_messages ();
}

/* EOF imgur-service.c */

