#ifndef IMAGESETMAKER_H
#define IMAGESETMAKER_H

#include <QMainWindow>
#include <QLabel>
#include <QDir>
#include <QTextStream>
#include <QMaemo5ValueButton>
#include <QBoxLayout>
#include <QMenuBar>
#include <QMenu>
#include <QAction>

namespace Ui {
    class imageSetMaker;
}

class imageSetMaker : public QMainWindow
{
    Q_OBJECT

public:
    explicit imageSetMaker(QWidget* parent = 0);
    ~imageSetMaker();

private:
    Ui::imageSetMaker* ui;

    /************ FUNCTIONS **************/
    void openImage(int);

    bool resCheck(QString);

    // Is called after opening proper image
    void setupCopyToBtn(int);

    // Is called by slot clickedCopyToBtn, creates copyToDialog with curCopyToBtn disabled
    void createCopyToDialog(int);
    // Creates buttons for copyToDialog
    void createCopyToDialogBtns();

    // Updates imgBtnPrev# according to imgPath(int)
    void updateImg(int);

    void setupIsmMenuBar();

    void saveDesktopFile();
    void createOverwriteDialog();
    void checkDesktopFileSaved();

    /************ VARIABLES **************/
    // One int to rule them all! (for-loops)
    int i;
    // int j is used in copyToOthers(), called functions from copyToOthers() use int i
    int j;

    QString* fileWithPath;
    bool* properImage;
    QDir lastUsedDir;
    QString nameEditLower;

    // Variables below are for saving .desktop file
    QFile saveFile;
    QTextStream fileContent;

    QList<QString*> imgPath;
    QList<QPushButton*> imgBtnPrev;

    // Buttons under imgBtnPrev# (main screen)
    QList<QPushButton*> copyToBtn;

    // Check if copyToBtn# exists
    QList<bool*> copyToBtnExists;

    // Put vertical layouts (from ui) in QList for convenience of index number
    QList<QVBoxLayout*> vertLayout;

    // copyToDialog + buttons and layout (after clicking copyToBtn#)
    // also a check if it exists, don't make multiple
    bool copyToDialogExists;
    QDialog* copyToDialog;
        QList<QPushButton*> copyToDialogBtn;
        QPushButton* copyToDialogOK;
        QHBoxLayout* copyToDialogH1;
        QHBoxLayout* copyToDialogH2;
        QVBoxLayout* copyToDialogV;

    // Is defined in createCopyToDialog(), tells which copyToDialogBtn is pressed
    // so copyToOthers() knows the source path from which it needs to copy
    int curCopyToBtn;

    // Takes path from source defined by curCopyToBtn
    QString* srcPath;

    // The menu and its actions
    QMenu* ismMenu;
    QAction* ismMenuActionReset;
    QAction* ismMenuActionAbout;

    // The overwrite dialog with its contents
    bool overwriteDialogExists;
    QDialog* overwriteDialog;
        QHBoxLayout* owHLayout;
        QVBoxLayout* owVLayout1;
        QVBoxLayout* owVLayout2;
        QLabel* owQuestion;
        QPushButton* owYes;
        QPushButton* owNo;

    // The About dialog with its contents
    bool aboutDialogExists;
    QDialog* aboutDialog;
        QLabel* aboutIcon;
        QLabel* aboutText;
        QPushButton* aboutOK;
        QVBoxLayout* aboutLayoutV1;
        QVBoxLayout* aboutLayoutV2;
        QVBoxLayout* aboutLayoutV3;
        QHBoxLayout* aboutLayoutH;

public slots:
    // Slots for imgBtnPrev#, these slots open openImage()
    void clickedImgBtnPrev0();
    void clickedImgBtnPrev1();
    void clickedImgBtnPrev2();
    void clickedImgBtnPrev3();

    // This also updates nameEditLower, which is the filename
    void updateSaveBtn();
    void setSaveFile();

    // Called when clicking on copyToBtn# (on main screen)
    void clickedCopyToBtn0();
    void clickedCopyToBtn1();
    void clickedCopyToBtn2();
    void clickedCopyToBtn3();

    void createAboutDialog();

    void confirmOverwrite();

    void copyToOthers();

    // Empty everything
    void resetScreen();
};

#endif // IMAGESETMAKER_H
