/*
  This source is part of the Illumination library
  Copyright (C) 2010  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Def/Props.h>

#include <Lum/Base/L10N.h>

#include <Lum/OS/Event.h>

namespace Lum {
  namespace Def {

    PropItem::PropItem()
    {
      // no code
    }

    PropItem::~PropItem()
    {
      // no code
    }

    PropBoolean::PropBoolean(const Boolean& boolean)
    : boolean(boolean)
    {
      // no code
    }

    const Boolean& PropBoolean::GetValue() const
    {
      return boolean;
    }

    PropInt::PropInt(const Int& number)
    : number(number)
    {
      // no code
    }

    const Int& PropInt::GetValue() const
    {
      return number;
    }

    PropUInt::PropUInt(const UInt& number)
    : number(number)
    {
      // no code
    }

    const UInt& PropUInt::GetValue() const
    {
      return number;
    }

    PropLong::PropLong(const Long& number)
    : number(number)
    {
      // no code
    }

    const Long& PropLong::GetValue() const
    {
      return number;
    }

    PropULong::PropULong(const ULong& number)
    : number(number)
    {
      // no code
    }

    const ULong& PropULong::GetValue() const
    {
      return number;
    }

    PropSizeT::PropSizeT(const SizeT& number)
    : number(number)
    {
      // no code
    }

    const SizeT& PropSizeT::GetValue() const
    {
      return number;
    }

    PropOneOfMany::PropOneOfMany(const OneOfMany& oneOfMany)
    : oneOfMany(oneOfMany)
    {
      // no code
    }

    const OneOfMany& PropOneOfMany::GetValue() const
    {
      return oneOfMany;
    }

    PropOneOfN::PropOneOfN(const OneOfN& oneOfN)
    : oneOfN(oneOfN)
    {
      // no code
    }

    const OneOfN& PropOneOfN::GetValue() const
    {
      return oneOfN;
    }

    PropGroup::PropGroup(PropGroup* parent, const Desc& description)
    : parent(parent),
    description(description)
    {
      // no code
    }

    PropGroup::PropGroup()
    : parent(NULL)
    {
      // no code
    }

    PropGroup::PropGroup(const PropGroup& other)
    {
      parent=NULL;
      description=other.description;

      for (std::list<PropItem*>::const_iterator prop=other.props.begin();
           prop!=other.props.end();
           ++prop) {
        if (dynamic_cast<PropBoolean*>(*prop)!=NULL) {
          props.push_back(new PropBoolean(*dynamic_cast<PropBoolean*>(*prop)));
        }
        else if (dynamic_cast<PropInt*>(*prop)!=NULL) {
          props.push_back(new PropInt(*dynamic_cast<PropInt*>(*prop)));
        }
        else if (dynamic_cast<PropUInt*>(*prop)!=NULL) {
          props.push_back(new PropUInt(*dynamic_cast<PropUInt*>(*prop)));
        }
        else if (dynamic_cast<PropLong*>(*prop)!=NULL) {
          props.push_back(new PropLong(*dynamic_cast<PropLong*>(*prop)));
        }
        else if (dynamic_cast<PropULong*>(*prop)!=NULL) {
          props.push_back(new PropULong(*dynamic_cast<PropULong*>(*prop)));
        }
        else if (dynamic_cast<PropSizeT*>(*prop)!=NULL) {
          props.push_back(new PropSizeT(*dynamic_cast<PropSizeT*>(*prop)));
        }
        else if (dynamic_cast<PropIntInterval*>(*prop)!=NULL) {
          props.push_back(new PropIntInterval(*dynamic_cast<PropIntInterval*>(*prop)));
        }
        else if (dynamic_cast<PropUIntInterval*>(*prop)!=NULL) {
          props.push_back(new PropUIntInterval(*dynamic_cast<PropUIntInterval*>(*prop)));
        }
        else if (dynamic_cast<PropLongInterval*>(*prop)!=NULL) {
          props.push_back(new PropLongInterval(*dynamic_cast<PropLongInterval*>(*prop)));
        }
        else if (dynamic_cast<PropULongInterval*>(*prop)!=NULL) {
          props.push_back(new PropULongInterval(*dynamic_cast<PropULongInterval*>(*prop)));
        }
        else if (dynamic_cast<PropSizeTInterval*>(*prop)!=NULL) {
          props.push_back(new PropSizeTInterval(*dynamic_cast<PropSizeTInterval*>(*prop)));
        }
        else if (dynamic_cast<PropOneOfMany*>(*prop)!=NULL) {
          props.push_back(new PropOneOfMany(*dynamic_cast<PropOneOfMany*>(*prop)));
        }
        else if (dynamic_cast<PropOneOfN*>(*prop)!=NULL) {
          props.push_back(new PropOneOfN(*dynamic_cast<PropOneOfN*>(*prop)));
        }
        else if (dynamic_cast<PropGroup*>(*prop)!=NULL) {
          PropGroup *group=new PropGroup(*dynamic_cast<PropGroup*>(*prop));

          group->parent=this;

          props.push_back(group);
        }
        else {
          assert(false);
        }
      }
    }

    PropGroup::~PropGroup()
    {
      for (std::list<PropItem*>::iterator prop=props.begin();
           prop!=props.end();
           ++prop) {
        delete *prop;
      }
    }


    PropGroup* PropGroup::Boolean(const Def::Boolean& boolean)
    {
      props.push_back(new PropBoolean(boolean));

      return this;
    }

    PropGroup* PropGroup::Int(const Def::Int& number)
    {
      props.push_back(new PropInt(number));

      return this;
    }

    PropGroup* PropGroup::UInt(const Def::UInt& number)
    {
      props.push_back(new PropUInt(number));

      return this;
    }

    PropGroup* PropGroup::Long(const Def::Long& number)
    {
      props.push_back(new PropLong(number));

      return this;
    }

    PropGroup* PropGroup::ULong(const Def::ULong& number)
    {
      props.push_back(new PropULong(number));

      return this;
    }

    PropGroup* PropGroup::SizeT(const Def::SizeT& number)
    {
      props.push_back(new PropSizeT(number));

      return this;
    }

    PropGroup* PropGroup::IntInterval(const Desc& desc,
                                      const Def::Int& start,
                                      const Def::Int& end)
    {
      props.push_back(new PropIntInterval(desc,start,end));

      return this;
    }

    PropGroup* PropGroup::UIntInterval(const Desc& desc,
                                       const Def::UInt& start,
                                       const Def::UInt& end)
    {
      props.push_back(new PropUIntInterval(desc,start,end));

      return this;
    }

    PropGroup* PropGroup::LongInterval(const Desc& desc,
                                       const Def::Long& start,
                                       const Def::Long& end)
    {
      props.push_back(new PropLongInterval(desc,start,end));

      return this;
    }

    PropGroup* PropGroup::ULongInterval(const Desc& desc,
                                        const Def::ULong& start,
                                        const Def::ULong& end)
    {
      props.push_back(new PropULongInterval(desc,start,end));

      return this;
    }

    PropGroup* PropGroup::SizeTInterval(const Desc& desc,
                                        const Def::SizeT& start,
                                        const Def::SizeT& end)
    {
      props.push_back(new PropSizeTInterval(desc,start,end));

      return this;
    }

    PropGroup* PropGroup::OneOfMany(const Def::OneOfMany& oneOfMany)
    {
      props.push_back(new PropOneOfMany(oneOfMany));

      return this;
    }

    PropGroup* PropGroup::OneOfN(const Def::OneOfN& oneOfN)
    {
      props.push_back(new PropOneOfN(oneOfN));

      return this;
    }

    PropGroup* PropGroup::Group(const Def::Desc& description)
    {
      PropGroup *group=new PropGroup(this,description);

      props.push_back(group);

      return group;
    }

    PropGroup* PropGroup::Group(const std::wstring& name)
    {
      PropGroup *group=new PropGroup(this,Desc(name));

      props.push_back(group);

      return group;
    }

    PropGroup* PropGroup::End()
    {
      return parent;
    }

    PropGroup* PropGroup::Append(PropGroup* group)
    {
      assert(group!=NULL);

      for (std::list<PropItem*>::const_iterator prop=group->props.begin();
           prop!=group->props.end();
           ++prop) {
        if (dynamic_cast<PropBoolean*>(*prop)!=NULL) {
          props.push_back(new PropBoolean(*dynamic_cast<PropBoolean*>(*prop)));
        }
        else if (dynamic_cast<PropInt*>(*prop)!=NULL) {
          props.push_back(new PropInt(*dynamic_cast<PropInt*>(*prop)));
        }
        else if (dynamic_cast<PropUInt*>(*prop)!=NULL) {
          props.push_back(new PropUInt(*dynamic_cast<PropUInt*>(*prop)));
        }
        else if (dynamic_cast<PropLong*>(*prop)!=NULL) {
          props.push_back(new PropLong(*dynamic_cast<PropLong*>(*prop)));
        }
        else if (dynamic_cast<PropULong*>(*prop)!=NULL) {
          props.push_back(new PropULong(*dynamic_cast<PropULong*>(*prop)));
        }
        else if (dynamic_cast<PropSizeT*>(*prop)!=NULL) {
          props.push_back(new PropSizeT(*dynamic_cast<PropSizeT*>(*prop)));
        }
        else if (dynamic_cast<PropIntInterval*>(*prop)!=NULL) {
          props.push_back(new PropIntInterval(*dynamic_cast<PropIntInterval*>(*prop)));
        }
        else if (dynamic_cast<PropUIntInterval*>(*prop)!=NULL) {
          props.push_back(new PropUIntInterval(*dynamic_cast<PropUIntInterval*>(*prop)));
        }
        else if (dynamic_cast<PropLongInterval*>(*prop)!=NULL) {
          props.push_back(new PropLongInterval(*dynamic_cast<PropLongInterval*>(*prop)));
        }
        else if (dynamic_cast<PropULongInterval*>(*prop)!=NULL) {
          props.push_back(new PropULongInterval(*dynamic_cast<PropULongInterval*>(*prop)));
        }
        else if (dynamic_cast<PropSizeTInterval*>(*prop)!=NULL) {
          props.push_back(new PropSizeTInterval(*dynamic_cast<PropSizeTInterval*>(*prop)));
        }
        else if (dynamic_cast<PropOneOfMany*>(*prop)!=NULL) {
          props.push_back(new PropOneOfMany(*dynamic_cast<PropOneOfMany*>(*prop)));
        }
        else if (dynamic_cast<PropOneOfN*>(*prop)!=NULL) {
          props.push_back(new PropOneOfN(*dynamic_cast<PropOneOfN*>(*prop)));
        }
        else if (dynamic_cast<PropGroup*>(*prop)!=NULL) {
          PropGroup *group=new PropGroup(*dynamic_cast<PropGroup*>(*prop));

          group->parent=this;

          props.push_back(group);
        }
        else {
          assert(false);
        }
      }

      return this;
    }

    const Desc& PropGroup::GetDesc() const
    {
      return description;
    }

    const std::list<PropItem*>& PropGroup::GetProps() const
    {
      return props;
    }

    PropGroup* PropGroup::Create()
    {
      return new PropGroup();
    }
  }
}
