/*
  This source is part of the Illumination library
  Copyright (C) 2004  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/OS/Main.h>

#include <Lum/Base/String.h>

#include <Lum/OS/Probe.h>

namespace Lum {
  namespace OS {

    Main::~Main()
    {
      // no code
    }

    bool MainBase::Initialize(const std::wstring& appName, int argc, char* argv[])
    {
      this->appName=appName;
      this->progName=Lum::Base::StringToWString(argv[0]);

      if (argc>1) {
        args.resize(argc-1);

        for (int i=1; i<argc; i++) {
          args[i-1]=Lum::Base::StringToWString(argv[i]);
        }
      }

      return Prepare();
    }

    bool MainBase::Prepare()
    {
      return true;
    }

    void MainBase::Cleanup()
    {
      // no code
    }

    void MainBase::OnDumpStatus()
    {
      // no code
    }

    MainIllumination::MainIllumination()
    {
      Lum::OS::prober.Instance();
    }

    bool MainIllumination::Prepare()
    {
      if (!MainBase::Prepare()) {
        return false;
      }

      return Lum::OS::prober->Open(appName,progName,args);
    }

    void MainIllumination::Cleanup()
    {
      Lum::OS::prober->Close();

      MainBase::Cleanup();
    }
  }
}
