/*
  This source is part of the Illumination library
  Copyright (C) 2005  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/OS/X11/Bitmap.h>

#include <Lum/OS/X11/Display.h>

namespace Lum {
  namespace OS {
    namespace X11 {

      Bitmap::Bitmap(size_t width, size_t height)
      : ::Lum::OS::Base::Bitmap(width,height)
      {
        display=dynamic_cast<Display*>(OS::display)->display;
        pixmap=XCreatePixmap(display,
                             XDefaultRootWindow(display),
                             width,height,
                             OS::display->GetColorDepth());

        draw=OS::driver->CreateDrawInfo(this);
      }

      Bitmap::~Bitmap()
      {
        delete draw;
        XFreePixmap(dynamic_cast<Display*>(OS::display)->display,pixmap);
      }

      ::Drawable Bitmap::GetDrawable() const
      {
        return pixmap;
      }

      ::Display* Bitmap::GetDisplay() const
      {
        return display;
      }
    }
  }
}
