#ifndef LUM_OS_BEHAVIOUR_H
#define LUM_OS_BEHAVIOUR_H

/*
  This source is part of the Illumination library
  Copyright (C) 2009  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <set>

#include <Lum/Private/ImportExport.h>

#include <Lum/Base/Model.h>

#include <Lum/Def/Menu.h>
#include <Lum/Def/MultiView.h>
#include <Lum/Def/OneOfMany.h>

#include <Lum/OS/Window.h>

namespace Lum {

  // Forward declaration of dialog because of recursive import of CustomMenuHandler
  class Dialog;

  namespace OS {


    /**
      A abstract base class for holding all information for influencing the behaviour
      of an user interface.

      Behaviour should try to operate on objects in the namespace Lum::Def and return
      approviate controls for implementing the required behaviour hinted by the
      abstract definitions.

      Clearly visual aspects should be implemented in Lum::OS::Theme.
    */
    class LUMAPI Behaviour
    {
    public:
      class CustomMenuHandler
      {
      protected:
        OS::Window *window;

      public:
        CustomMenuHandler(OS::Window* window);
        virtual ~CustomMenuHandler();

        virtual bool SetMenu(Def::Menu* def,
                             const std::set<Lum::Base::Model*>& excludes) = 0;
        virtual bool Open() = 0;
      };

    public:
      Behaviour();
      virtual ~Behaviour();

      /**
        @name Menu
        Using system specific menu implementation
      */
      //@{
      virtual CustomMenuHandler* GetCustomMenuHandler(OS::Window* window) const = 0;
      //@}

      /**
        @name Dlg
        Choosing between different dialog representations
      */
      //@{
      virtual void ApplyMultiViewDlg(Dialog* dialog,
                                     const Def::MultiView& multiView) const = 0;
      //@}

      /**
        @name Controls
        Choosing between different control implementation
      */
      //@{
      virtual Lum::Object* GetOneOfManyControl(Def::OneOfMany& def) const = 0;
      virtual Lum::Object* GetOneOfManyControl(Def::OneOfMany& def,
                                               bool horizFlex,
                                               bool vertFlex) const = 0;
      /**
        @name Behaviours
        Choosing between different behaviours.
      */
      //@}
    };
  }
}

#endif
