/*
  This source is part of the Illumination library
  Copyright (C) 2004  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/OS/Manager/Repository.h>

#include <Lum/Private/Config.h>

#if defined(HAVE_LIB_HILDON)
  #include <Lum/OS/Hildon/DisplayManager.h>
  #include <Lum/OS/Hildon/KeyboardManager.h>
#endif

namespace Lum {
  namespace OS {
    namespace Manager {

      static Repository*               singletonStore;
      Lum::Base::Singleton<Repository> repository(&singletonStore);

      Repository::Repository()
      : displayManager(NULL),
        keyboardManager(NULL),
        networkManager(NULL)
      {
        // no code
      }

      Repository::~Repository()
      {
        delete displayManager;
        delete keyboardManager;
        delete networkManager;
      }

      DisplayManager* Repository::GetDisplayManager()
      {
        if (displayManager==NULL) {
#if defined(HAVE_LIB_HILDON)
          displayManager=new Lum::OS::Hildon::DisplayManager();
#endif
        }
        return displayManager;
      }

      KeyboardManager* Repository::GetKeyboardManager()
      {
        if (keyboardManager==NULL) {
#if defined(HAVE_LIB_HILDON)
          keyboardManager=new Lum::OS::Hildon::KeyboardManager();
#endif
        }
        return keyboardManager;
      }

      NetworkManager* Repository::GetNetworkManager()
      {
        return networkManager;
      }
    }
  }
}
