/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.security.util.Cache;

class MemoryCache
extends Cache {
    private static final float LOAD_FACTOR = 0.75f;
    private static final boolean DEBUG = false;
    private final Map<Object, CacheEntry> cacheMap;
    private final int maxSize;
    private final int lifetime;
    private final ReferenceQueue queue;

    public MemoryCache(boolean soft, int maxSize) {
        this(soft, maxSize, 0);
    }

    public MemoryCache(boolean soft, int maxSize, int lifetime) {
        this.maxSize = maxSize;
        this.lifetime = lifetime * 1000;
        this.queue = soft ? new ReferenceQueue() : null;
        int buckets = (int)((float)maxSize / 0.75f) + 1;
        this.cacheMap = new LinkedHashMap<Object, CacheEntry>(buckets, 0.75f, true);
    }

    private void emptyQueue() {
        CacheEntry entry;
        if (this.queue == null) {
            return;
        }
        int startSize = this.cacheMap.size();
        while ((entry = (CacheEntry)((Object)this.queue.poll())) != null) {
            CacheEntry currentEntry;
            Object key = entry.getKey();
            if (key == null || (currentEntry = this.cacheMap.remove(key)) == null || entry == currentEntry) continue;
            this.cacheMap.put(key, currentEntry);
        }
    }

    private void expungeExpiredEntries() {
        this.emptyQueue();
        if (this.lifetime == 0) {
            return;
        }
        int cnt = 0;
        long time = System.currentTimeMillis();
        Iterator<CacheEntry> t = this.cacheMap.values().iterator();
        while (t.hasNext()) {
            CacheEntry entry = t.next();
            if (entry.isValid(time)) continue;
            t.remove();
            ++cnt;
        }
    }

    public synchronized int size() {
        this.expungeExpiredEntries();
        return this.cacheMap.size();
    }

    public synchronized void clear() {
        if (this.queue != null) {
            for (CacheEntry entry : this.cacheMap.values()) {
                entry.invalidate();
            }
            while (this.queue.poll() != null) {
            }
        }
        this.cacheMap.clear();
    }

    public synchronized void put(Object key, Object value) {
        this.emptyQueue();
        long expirationTime = this.lifetime == 0 ? 0L : System.currentTimeMillis() + (long)this.lifetime;
        CacheEntry newEntry = this.newEntry(key, value, expirationTime, this.queue);
        CacheEntry oldEntry = this.cacheMap.put(key, newEntry);
        if (oldEntry != null) {
            oldEntry.invalidate();
            return;
        }
        if (this.cacheMap.size() > this.maxSize) {
            this.expungeExpiredEntries();
            if (this.cacheMap.size() > this.maxSize) {
                Iterator<CacheEntry> t = this.cacheMap.values().iterator();
                CacheEntry lruEntry = t.next();
                t.remove();
                lruEntry.invalidate();
            }
        }
    }

    public synchronized Object get(Object key) {
        long time;
        this.emptyQueue();
        CacheEntry entry = this.cacheMap.get(key);
        if (entry == null) {
            return null;
        }
        long l = time = this.lifetime == 0 ? 0L : System.currentTimeMillis();
        if (!entry.isValid(time)) {
            this.cacheMap.remove(key);
            return null;
        }
        return entry.getValue();
    }

    public synchronized void remove(Object key) {
        this.emptyQueue();
        CacheEntry entry = this.cacheMap.remove(key);
        if (entry != null) {
            entry.invalidate();
        }
    }

    protected CacheEntry newEntry(Object key, Object value, long expirationTime, ReferenceQueue queue) {
        if (queue != null) {
            return new SoftCacheEntry(key, value, expirationTime, queue);
        }
        return new HardCacheEntry(key, value, expirationTime);
    }

    private static class SoftCacheEntry
    extends SoftReference
    implements CacheEntry {
        private Object key;
        private long expirationTime;

        SoftCacheEntry(Object key, Object value, long expirationTime, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
            this.expirationTime = expirationTime;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.get();
        }

        public boolean isValid(long currentTime) {
            boolean valid;
            boolean bl = valid = currentTime <= this.expirationTime && this.get() != null;
            if (!valid) {
                this.invalidate();
            }
            return valid;
        }

        public void invalidate() {
            this.clear();
            this.key = null;
            this.expirationTime = -1L;
        }
    }

    private static class HardCacheEntry
    implements CacheEntry {
        private Object key;
        private Object value;
        private long expirationTime;

        HardCacheEntry(Object key, Object value, long expirationTime) {
            this.key = key;
            this.value = value;
            this.expirationTime = expirationTime;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isValid(long currentTime) {
            boolean valid;
            boolean bl = valid = currentTime <= this.expirationTime;
            if (!valid) {
                this.invalidate();
            }
            return valid;
        }

        public void invalidate() {
            this.key = null;
            this.value = null;
            this.expirationTime = -1L;
        }
    }

    private static interface CacheEntry {
        public boolean isValid(long var1);

        public void invalidate();

        public Object getKey();

        public Object getValue();
    }
}

