/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.services.XFileContents;

class XFileSaveService
implements FileSaveService {
    protected XFileSaveService() {
    }

    @Override
    public FileContents saveFileDialog(String pathHint, String[] extensions, InputStream stream, String name) throws IOException {
        if (ServiceUtil.checkAccess(SecurityWarningDialog.AccessType.WRITE_FILE, new Object[0])) {
            JFileChooser chooser = new JFileChooser();
            int chosen = chooser.showSaveDialog(null);
            if (chosen == 0) {
                this.writeToFile(stream, chooser.getSelectedFile());
                return (FileContents)ServiceUtil.createPrivilegedProxy(FileContents.class, new XFileContents(chooser.getSelectedFile()));
            }
            return null;
        }
        return null;
    }

    @Override
    public FileContents saveAsFileDialog(String pathHint, String[] extensions, FileContents contents) throws IOException {
        if (ServiceUtil.checkAccess(SecurityWarningDialog.AccessType.WRITE_FILE, new Object[0])) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(new File(contents.getName()));
            int chosen = chooser.showSaveDialog(null);
            if (chosen == 0) {
                this.writeToFile(contents.getInputStream(), chooser.getSelectedFile());
                return (FileContents)ServiceUtil.createPrivilegedProxy(FileContents.class, new XFileContents(chooser.getSelectedFile()));
            }
            return null;
        }
        return null;
    }

    private void writeToFile(InputStream stream, File file) throws IOException {
        FileOutputStream out;
        if (!file.createNewFile()) {
            boolean replace;
            boolean bl = replace = JOptionPane.showConfirmDialog(null, file.getAbsolutePath() + " already exists.\n" + "Do you want to replace it?", "Warning - File Exists", 0) == 0;
            if (!replace) {
                return;
            }
        } else {
            file.createNewFile();
        }
        if (file.canWrite()) {
            out = new FileOutputStream(file);
            byte[] b = new byte[256];
            int read = 0;
            while ((read = stream.read(b)) > 0) {
                out.write(b, 0, read);
            }
        } else {
            throw new IOException("Unable to open file for writing");
        }
        out.flush();
        out.close();
    }
}

