/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogUI;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import sun.misc.Launcher;

public class MoreInfoPane
extends SecurityDialogUI {
    public MoreInfoPane(JComponent x, CertVerifier certVerifier) {
        super(x, certVerifier);
    }

    @Override
    protected void installComponents() {
        ArrayList<String> details = this.certVerifier.getDetails();
        int numLabels = details.size();
        JPanel errorPanel = new JPanel(new GridLayout(numLabels, 1));
        errorPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        errorPanel.setPreferredSize(new Dimension(400, 70 * numLabels));
        for (int i = 0; i < numLabels; ++i) {
            ImageIcon icon = null;
            icon = details.get(i).equals(MoreInfoPane.R("STrustedCertificate")) ? new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/info-small.png")) : new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/warning-small.png"));
            errorPanel.add(new JLabel(this.htmlWrap(details.get(i)), icon, 2));
        }
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        JButton certDetails = new JButton("Certificate Details");
        certDetails.addActionListener(new CertInfoButtonListener());
        JButton close = new JButton("Close");
        close.addActionListener(this.createButtonActionListener(0));
        buttonsPanel.add((Component)certDetails, "West");
        buttonsPanel.add((Component)close, "East");
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)errorPanel, "North");
        main.add((Component)buttonsPanel, "South");
        this.optionPane.add(main);
    }

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    private String htmlWrap(String s) {
        return "<html>" + s + "</html>";
    }

    private class CertInfoButtonListener
    implements ActionListener {
        private CertInfoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SecurityWarningDialog.showCertInfoDialog(((SecurityWarningDialog)MoreInfoPane.this.optionPane).getJarSigner(), MoreInfoPane.this.optionPane);
        }
    }
}

